/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.launcher;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.launcher.CarbonServer;
import org.wso2.carbon.launcher.config.CarbonLaunchConfig;
import org.wso2.carbon.launcher.utils.Utils;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        if (System.getProperty("carbon.start.time") == null) {
            System.setProperty("carbon.start.time", System.currentTimeMillis() + "");
        }
        Main.processCmdLineArgs(args);
        Main.initAndVerifySysProps();
        CarbonLaunchConfig config = Main.loadCarbonLaunchConfig();
        CarbonServer carbonServer = new CarbonServer(config);
        Main.registerShutdownHook(carbonServer);
        Main.writePID(System.getProperty("wso2.runtime.path"));
        try {
            carbonServer.start();
            boolean restart = Boolean.parseBoolean(System.getProperty("carbon.server.restart"));
            if (restart) {
                System.exit(121);
            } else {
                System.exit(0);
            }
        }
        catch (Throwable e) {
            carbonServer.stop();
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(-1);
        }
    }

    private static CarbonLaunchConfig loadCarbonLaunchConfig() {
        File launchPropFile = Utils.getLaunchConfigDirectory().resolve("launch.properties").toFile();
        if (launchPropFile.exists()) {
            logger.log(Level.FINE, "Loading the Carbon launch configuration from the file " + launchPropFile.getAbsolutePath());
            return new CarbonLaunchConfig(launchPropFile);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Loading the Carbon launch configuration from the launch.properties file in the classpath");
        }
        return new CarbonLaunchConfig();
    }

    private static void registerShutdownHook(final CarbonServer carbonServer) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                carbonServer.stop();
            }
        });
    }

    private static void initAndVerifySysProps() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null || carbonHome.length() == 0) {
            String msg = "carbon.home system property must be set before starting the server";
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(msg);
        }
        String profileName = System.getProperty("wso2.runtime");
        if (profileName == null || profileName.length() == 0) {
            System.setProperty("wso2.runtime", "default");
        }
        System.setProperty("org.ops4j.pax.logging.DefaultServiceLog.level", "WARN");
        System.setProperty("org.ops4j.pax.logging.ranking", String.valueOf(Integer.MAX_VALUE));
        Path paxLoggingPropertiesFile = Paths.get(System.getProperty("carbon.home"), "conf", System.getProperty("wso2.runtime"), "etc", "pax-logging.properties");
        if (!paxLoggingPropertiesFile.toFile().exists()) {
            String msg = "pax-logging.properties should be available to start the server";
            logger.log(Level.SEVERE, msg);
            throw new RuntimeException(msg);
        }
        System.setProperty("org.ops4j.pax.logging.property.file", paxLoggingPropertiesFile.toAbsolutePath().toString());
        logger.log(Level.FINE, "Setting pax logging properties file path to : " + paxLoggingPropertiesFile.toAbsolutePath().toString());
    }

    public static void processCmdLineArgs(String[] args) {
        Arrays.asList(args).stream().filter(arg -> arg.startsWith("-D")).forEach(arg -> {
            String value;
            String property;
            int indexOfEq = arg.indexOf(61);
            if (indexOfEq != -1) {
                property = arg.substring(2, indexOfEq);
                value = arg.substring(indexOfEq + 1);
            } else {
                property = arg.substring(2);
                value = "true";
            }
            System.setProperty(property, value);
        });
    }

    private static void writePID(String runtimePath) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int indexOfAt = jvmName.indexOf(64);
        if (indexOfAt < 1) {
            logger.log(Level.WARNING, "Cannot extract current process ID from JVM name '" + jvmName + "'.");
            return;
        }
        String pid = jvmName.substring(0, indexOfAt);
        Path runtimePidFile = Paths.get(runtimePath, "runtime.pid");
        try {
            Files.write(runtimePidFile, pid.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Cannot write process ID '" + pid + "' to '" + runtimePidFile.toString() + "' file.", e);
        }
    }
}

