/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.launcher.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.wso2.carbon.launcher.CarbonServerListener;
import org.wso2.carbon.launcher.config.CarbonInitialBundle;
import org.wso2.carbon.launcher.utils.FileResolver;
import org.wso2.carbon.launcher.utils.Utils;

public class CarbonLaunchConfig {
    private static final Logger logger = Logger.getLogger(CarbonLaunchConfig.class.getName());
    private static final String VAR_REGEXP = "(?<=@)(\\d+)";
    private static final Pattern VAR_PATTERN = Pattern.compile("(?<=@)(\\d+)");
    private URL carbonOSGiRepository;
    private URL carbonProfileRepository;
    private URL carbonOSGiFramework;
    private URL osgiInstallArea;
    private URL osgiConfigurationArea;
    private URL osgiInstanceArea;
    private URL eclipseP2DataArea;
    private String carbonHome;
    private String carbonOSGiRepositoryPath;
    private String carbonProfileRepositoryPath;
    private List<CarbonInitialBundle> initialBundles = new ArrayList<CarbonInitialBundle>();
    private List<CarbonServerListener> carbonServerListeners = new ArrayList<CarbonServerListener>();
    private Map<String, String> properties = new HashMap<String, String>();
    private static Comparator<String> initialBundleComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return this.extractInt(o1) - this.extractInt(o2);
        }

        int extractInt(String bundle) {
            Matcher matcher = VAR_PATTERN.matcher(bundle);
            if (!matcher.find()) {
                String errorMsg = "Invalid carbon.initial.osgi bundle found in launch.properties: " + bundle;
                logger.log(Level.SEVERE, errorMsg);
                throw new RuntimeException(errorMsg);
            }
            String num = matcher.group(0);
            return Integer.parseInt(num);
        }
    };

    public CarbonLaunchConfig() {
        this.loadCarbonConfiguration(null);
    }

    public CarbonLaunchConfig(File launchPropFile) {
        this.loadCarbonConfiguration(launchPropFile);
    }

    public CarbonLaunchConfig(URL launchPropURL) {
        this.loadCarbonConfiguration(launchPropURL);
    }

    private <T> void loadCarbonConfiguration(T source) {
        this.loadFromClasspath();
        if (source != null) {
            Properties customProperties = new Properties();
            if (source instanceof File) {
                customProperties = this.loadConfigurationFromFile((File)source);
            } else if (source instanceof URL) {
                customProperties = this.loadConfigurationFromUrl((URL)source);
            }
            this.mergeCustomProperties(customProperties);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Loaded properties from the launch.properties file.");
            this.properties.forEach((key, value) -> logger.log(Level.FINE, "Key: " + key + " Value: " + value));
        }
        this.initializeProperties();
    }

    private void mergeCustomProperties(Properties customProperties) {
        customProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if ("carbon.initial.osgi.bundles".equals(key)) {
                this.properties.put((String)key, this.generateInitialBundlesList(this.properties.get(key), (String)value));
            } else {
                this.properties.put((String)key, (String)value);
            }
        }));
    }

    private String generateInitialBundlesList(String defaultBundles, String customBundles) {
        String[] defaultBundlesArray = Utils.tokenize(defaultBundles, ",");
        String[] customBundlesArray = Utils.tokenize(customBundles, ",");
        List list = Arrays.stream(defaultBundlesArray).collect(Collectors.toList());
        list.addAll(list.size() - 1, Arrays.stream(customBundlesArray).collect(Collectors.toList()));
        Collections.sort(list, initialBundleComparator);
        return list.toString().substring(1, list.toString().length() - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadConfigurationFromFile(File launchPropFile) {
        try (FileInputStream fileInputStream = new FileInputStream(launchPropFile);){
            Properties properties = this.loadLaunchConfigurationFromStream(fileInputStream);
            return properties;
        }
        catch (FileNotFoundException e) {
            String errorMsg = "File " + launchPropFile + " does not exists";
            logger.log(Level.SEVERE, errorMsg, e);
            throw new RuntimeException(errorMsg, e);
        }
        catch (IOException e) {
            String errorMsg = "Exception while loading file " + launchPropFile;
            logger.log(Level.SEVERE, errorMsg, e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadConfigurationFromUrl(URL launchPropURL) {
        try (InputStream stream = launchPropURL.openStream();){
            Properties properties = this.loadLaunchConfigurationFromStream(stream);
            return properties;
        }
        catch (IOException e) {
            String errorMsg = "Error loading the launch.properties";
            logger.log(Level.SEVERE, errorMsg, e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    public URL getCarbonOSGiRepository() {
        return this.carbonOSGiRepository;
    }

    public URL getCarbonOSGiFramework() {
        return this.carbonOSGiFramework;
    }

    public URL getOSGiInstallArea() {
        return this.osgiInstallArea;
    }

    public URL getOSGiConfigurationArea() {
        return this.osgiConfigurationArea;
    }

    public URL getOSGiInstanceArea() {
        return this.osgiInstanceArea;
    }

    public URL getEclipseP2DataArea() {
        return this.eclipseP2DataArea;
    }

    public List<CarbonInitialBundle> getInitialBundles() {
        return Collections.unmodifiableList(this.initialBundles);
    }

    public String getCarbonHome() {
        return this.carbonHome;
    }

    public List<CarbonServerListener> getCarbonServerListeners() {
        return Collections.unmodifiableList(this.carbonServerListeners);
    }

    private void loadFromClasspath() {
        try (InputStream stream = CarbonLaunchConfig.class.getClassLoader().getResourceAsStream("launch.properties");){
            Properties defaultProperties = this.loadLaunchConfigurationFromStream(stream);
            defaultProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.properties.put((String)key, (String)value)));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Properties loadLaunchConfigurationFromStream(InputStream is) throws IOException {
        Properties launchProps = new Properties();
        launchProps.load(is);
        launchProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> launchProps.put((String)key, Utils.initializeSystemProperties((String)value))));
        return launchProps;
    }

    private void initializeProperties() {
        this.carbonHome = System.getProperty("carbon.home");
        this.carbonOSGiRepository = this.resolvePath(this.properties.get("carbon.osgi.repository"), this.carbonHome, "carbon.osgi.repository");
        this.carbonProfileRepository = this.resolvePath(this.properties.get("carbon.runtime.repository"), this.carbonHome, "carbon.runtime.repository");
        this.carbonOSGiRepositoryPath = this.carbonOSGiRepository.toExternalForm().substring(5);
        this.carbonProfileRepositoryPath = this.carbonProfileRepository.toExternalForm().substring(5);
        this.carbonOSGiFramework = this.resolvePath(this.properties.get("carbon.osgi.framework"), this.carbonOSGiRepositoryPath, "carbon.osgi.framework");
        this.osgiInstallArea = this.resolvePath(this.properties.get("osgi.install.area"), this.carbonProfileRepositoryPath, "osgi.install.area");
        this.osgiConfigurationArea = this.resolvePath(this.properties.get("osgi.configuration.area"), this.carbonProfileRepositoryPath, "osgi.configuration.area");
        this.osgiInstanceArea = this.resolvePath(this.properties.get("osgi.instance.area"), this.carbonProfileRepositoryPath, "osgi.instance.area");
        this.eclipseP2DataArea = this.resolvePath(this.properties.get("eclipse.p2.data.area"), this.carbonOSGiRepositoryPath, "eclipse.p2.data.area");
        this.populateInitialBundlesList(this.properties.get("carbon.initial.osgi.bundles"));
        this.loadCarbonServerListeners(this.properties.get("carbon.server.listeners"));
    }

    private URL resolvePath(String path, String parentPath, String key) {
        if (Utils.isNullOrEmpty(path)) {
            String errorMsg = "The property " + key + " must not be null or empty.";
            logger.log(Level.SEVERE, errorMsg);
            throw new RuntimeException("The property " + key + " must not be null or empty.");
        }
        URL url = FileResolver.resolve(path, parentPath);
        if (url == null) {
            throw new RuntimeException("URL must not be null.");
        }
        this.properties.put(key, url.toExternalForm());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Path: " + path);
            logger.log(Level.FINE, "Parent path: " + parentPath);
            logger.log(Level.FINE, "Resolved path: " + url.toExternalForm());
        }
        return url;
    }

    private void populateInitialBundlesList(String initialBundleList) {
        if (Utils.isNullOrEmpty(initialBundleList)) {
            return;
        }
        String[] strArray = Utils.tokenize(initialBundleList, ",");
        Pattern bundleEntryPattern = Pattern.compile("(file):(.*)@(.*):(.*)");
        for (String bundleEntry : strArray) {
            if (Utils.isNullOrEmpty(bundleEntry)) continue;
            Matcher matcher = bundleEntryPattern.matcher(bundleEntry.trim());
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid initial bundle entry: " + bundleEntry);
            }
            if (!"file".equals(matcher.group(1))) {
                throw new RuntimeException("URLs other than file URLs are not supported.");
            }
            String path = matcher.group(2);
            int bundleStartLevel = Integer.parseInt(matcher.group(3));
            boolean start = Boolean.parseBoolean(matcher.group(4));
            URL bundleURL = FileResolver.resolve("file:" + path, this.carbonOSGiRepositoryPath);
            this.initialBundles.add(new CarbonInitialBundle(bundleURL, bundleStartLevel, start));
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, "Initial bundle entry: " + bundleEntry);
            logger.log(Level.FINE, "Bundle URL: " + bundleURL.toExternalForm());
            logger.log(Level.FINE, "Bundle start level: " + bundleStartLevel);
            logger.log(Level.FINE, "Start flag: " + start);
        }
    }

    private void loadCarbonServerListeners(String serverListenersList) {
        String[] classNameArray;
        if (Utils.isNullOrEmpty(serverListenersList)) {
            return;
        }
        for (String className : classNameArray = Utils.tokenize(serverListenersList, ",")) {
            if (Utils.isNullOrEmpty(className)) continue;
            try {
                Class<?> clazz = Class.forName(className.trim());
                this.carbonServerListeners.add((CarbonServerListener)clazz.newInstance());
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Loaded CarbonServerListener: " + className);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

