/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault.ciphertool;

import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.wso2.carbon.secvault.MasterKeyReader;
import org.wso2.carbon.secvault.SecretRepository;
import org.wso2.carbon.secvault.SecureVaultUtils;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.wso2.carbon.secvault.model.SecureVaultConfiguration;

public class CipherTool {
    private static final Logger logger = Logger.getLogger(CipherTool.class.getName());
    private SecureVaultConfiguration secureVaultConfiguration;
    private SecretRepository secretRepository;

    public void init(URLClassLoader urlClassLoader, Path secureVaultConfigPath) throws SecureVaultException {
        MasterKeyReader masterKeyReader;
        this.secureVaultConfiguration = SecureVaultUtils.getSecureVaultConfig(secureVaultConfigPath).orElseThrow(() -> new SecurityException("Error occurred when obtaining secure vault configuration"));
        String secretRepositoryType = this.secureVaultConfiguration.getSecretRepositoryConfig().getType().orElseThrow(() -> new SecureVaultException("Secret repository type is mandatory"));
        String masterKeyReaderType = this.secureVaultConfiguration.getMasterKeyReaderConfig().getType().orElseThrow(() -> new SecureVaultException("Master key reader type is mandatory"));
        try {
            masterKeyReader = (MasterKeyReader)urlClassLoader.loadClass(masterKeyReaderType).newInstance();
            this.secretRepository = (SecretRepository)urlClassLoader.loadClass(secretRepositoryType).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SecureVaultException("Failed to instantiate implementation classes.", e);
        }
        masterKeyReader.init(this.secureVaultConfiguration.getMasterKeyReaderConfig());
        this.secretRepository.init(this.secureVaultConfiguration.getSecretRepositoryConfig(), masterKeyReader);
    }

    public void encryptSecrets() throws SecureVaultException {
        this.secretRepository.persistSecrets(this.secureVaultConfiguration.getSecretRepositoryConfig());
    }

    public char[] encryptText(String plainText) throws SecureVaultException {
        byte[] encryptedPassword = this.secretRepository.encrypt(SecureVaultUtils.toBytes(plainText.trim()));
        char[] base64Encoded = SecureVaultUtils.toChars(SecureVaultUtils.base64Encode(encryptedPassword));
        logger.info("Encrypted value : " + new String(base64Encoded));
        return base64Encoded;
    }

    public char[] decryptText(String cipherText) throws SecureVaultException {
        byte[] decryptedPassword = this.secretRepository.decrypt(SecureVaultUtils.base64Decode(SecureVaultUtils.toBytes(cipherText)));
        logger.info("Decrypted value : " + new String(SecureVaultUtils.toChars(decryptedPassword)));
        return SecureVaultUtils.toChars(decryptedPassword);
    }
}

