/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.secvault.ciphertool.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.secvault.ciphertool.exceptions.CipherToolException;
import org.wso2.carbon.secvault.ciphertool.utils.CommandLineParser;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());

    private Utils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static CommandLineParser createCommandLineParser(String ... toolArgs) throws CipherToolException {
        return new CommandLineParser(toolArgs);
    }

    public static URLClassLoader getCustomClassLoader(Optional<String> optCustomLibPath) {
        ArrayList urls = new ArrayList();
        optCustomLibPath.map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> path.toFile().exists() && path.toFile().isDirectory()).ifPresent(path -> urls.addAll(Utils.getJarURLs(path.toString())));
        Optional.ofNullable(System.getProperty("carbon.home")).ifPresent(carbonHome -> {
            urls.addAll(Utils.getJarURLs(Paths.get(carbonHome, "lib").toString()));
            urls.addAll(Utils.getJarURLs(Paths.get(carbonHome, "wso2/lib", "plugins").toString()));
        });
        return (URLClassLoader)AccessController.doPrivileged(() -> new URLClassLoader(urls.toArray(new URL[urls.size()])));
    }

    public static Object createCipherTool(URLClassLoader urlClassLoader, Path secureVaultConfigPath) throws CipherToolException {
        Object objCipherTool;
        try {
            objCipherTool = urlClassLoader.loadClass("org.wso2.carbon.secvault.ciphertool.CipherTool").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new CipherToolException("Unable to instantiate Cipher Tool", e);
        }
        try {
            Method initMethod = objCipherTool.getClass().getMethod("init", URLClassLoader.class, Path.class);
            initMethod.invoke(objCipherTool, urlClassLoader, secureVaultConfigPath);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CipherToolException("Failed to initialize Cipher Tool", e);
        }
        return objCipherTool;
    }

    private static List<URL> getJarURLs(String location) {
        File fileLocation = new File(location);
        ArrayList<URL> urls = new ArrayList<URL>();
        File[] fileList = fileLocation.listFiles(file -> file.getPath().toLowerCase().endsWith(".jar"));
        if (fileList != null) {
            for (File file2 : fileList) {
                urls.addAll(Utils.getInternalJarURLs(file2));
            }
        }
        return urls;
    }

    private static List<URL> getInternalJarURLs(File file) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            urls.add(file.getAbsoluteFile().toURI().toURL());
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Unable to add file url in to URL list", e);
        }
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".jar")) continue;
                JarEntry internalJar = jarFile.getJarEntry(entry.getName());
                InputStream inputStream = jarFile.getInputStream(internalJar);
                Throwable throwable = null;
                try {
                    File tempFile = File.createTempFile(internalJar.getName(), ".tmp");
                    tempFile.deleteOnExit();
                    try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) != -1) {
                            fileOutputStream.write(buffer, 0, length);
                        }
                    }
                    urls.add(tempFile.getAbsoluteFile().toURI().toURL());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "CipherTool exits with error", e);
        }
        return urls;
    }
}

