/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.wso2.carbon.uiserver.api.Configuration;
import org.wso2.carbon.uiserver.api.Extension;
import org.wso2.carbon.uiserver.api.I18nResource;
import org.wso2.carbon.uiserver.api.Page;
import org.wso2.carbon.uiserver.api.Theme;
import org.wso2.carbon.uiserver.api.exception.PageNotFoundException;
import org.wso2.carbon.uiserver.api.exception.PageRedirectException;
import org.wso2.carbon.uiserver.api.exception.RenderingException;
import org.wso2.carbon.uiserver.api.http.HttpRequest;
import org.wso2.carbon.uiserver.api.util.Multilocational;
import org.wso2.carbon.uiserver.api.util.Overridable;
import org.wso2.carbon.uiserver.internal.impl.OverriddenApp;

public class App
implements Multilocational,
Overridable<App> {
    private final String name;
    private final String contextPath;
    private final SortedSet<Page> pages;
    private final Map<String, Extension> extensions;
    private final Map<String, Theme> themes;
    private final Map<Locale, I18nResource> i18nResources;
    private final Configuration configuration;
    private final List<String> paths;

    public App(String name, String contextPath, SortedSet<Page> pages, Set<Extension> extensions, Set<Theme> themes, Set<I18nResource> i18nResources, Configuration configuration, String path) {
        this(name, contextPath, pages, extensions, themes, i18nResources, configuration, Collections.singletonList(path));
    }

    protected App(String name, String contextPath, SortedSet<Page> pages, Set<Extension> extensions, Set<Theme> themes, Set<I18nResource> i18nResources, Configuration configuration, List<String> paths) {
        this.name = name;
        this.contextPath = contextPath;
        this.pages = pages;
        this.extensions = extensions.stream().collect(Collectors.toMap(ext -> ext.getType() + ":" + ext.getName(), ext -> ext));
        this.themes = themes.stream().collect(Collectors.toMap(Theme::getName, t -> t));
        this.i18nResources = i18nResources.stream().collect(Collectors.toMap(I18nResource::getLocale, i18nResource -> i18nResource));
        this.configuration = configuration;
        this.paths = paths;
    }

    public String getName() {
        return this.name;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Set<Extension> getExtensions(String extensionType) {
        return this.extensions.values().stream().filter(extension -> Objects.equals(extension.getType(), extensionType)).collect(Collectors.toSet());
    }

    public Optional<Extension> getExtension(String extensionType, String extensionName) {
        return Optional.ofNullable(this.extensions.get(extensionType + ":" + extensionName));
    }

    public Optional<Theme> getTheme(String themeName) {
        return Optional.ofNullable(this.themes.get(themeName));
    }

    public Optional<I18nResource> getI18nResource(Locale locale) {
        return Optional.ofNullable(this.i18nResources.get(locale));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    public String renderPage(HttpRequest request) throws RenderingException, PageNotFoundException, PageRedirectException {
        String uriWithoutContextPath = request.getUriWithoutContextPath();
        Page matchingPage = this.getMatchingPage(uriWithoutContextPath);
        if (matchingPage != null) {
            return matchingPage.render(request, this.configuration);
        }
        String correctedUriWithoutContextPath = uriWithoutContextPath.endsWith("/") ? uriWithoutContextPath.substring(0, uriWithoutContextPath.length() - 1) : uriWithoutContextPath + "/";
        matchingPage = this.getMatchingPage(correctedUriWithoutContextPath);
        if (matchingPage != null) {
            String correctedUri = request.getContextPath() + correctedUriWithoutContextPath;
            if (request.getQueryString() != null) {
                correctedUri = correctedUri + '?' + request.getQueryString();
            }
            throw new PageRedirectException(correctedUri);
        }
        throw new PageNotFoundException("Requested page '" + uriWithoutContextPath + "' does not exists.");
    }

    private Page getMatchingPage(String uriWithoutContextPath) {
        for (Page page : this.pages) {
            if (!page.matches(uriWithoutContextPath)) continue;
            return page;
        }
        return null;
    }

    @Override
    public App override(App override) {
        if (!this.canOverrideBy(override)) {
            throw new IllegalArgumentException(this + " cannot be overridden by " + override + " .");
        }
        return new OverriddenApp(this, override);
    }

    @Override
    public App getBase() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.contextPath, other.contextPath) && Objects.equals(this.paths, other.paths);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.contextPath);
    }

    public String toString() {
        return "App{name='" + this.name + "', contextPath='" + this.contextPath + "', paths=" + this.paths + "}";
    }

    protected static SortedSet<Page> getPagesOf(App app) {
        return app.pages;
    }

    protected static Collection<Extension> getExtensionsOf(App app) {
        return app.extensions.values();
    }

    protected static Collection<Theme> getThemesOf(App app) {
        return app.themes.values();
    }

    protected static Collection<I18nResource> getI18nResourcesOf(App app) {
        return app.i18nResources.values();
    }
}

