/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    public static final Configuration DEFAULT_CONFIGURATION = new Configuration(new HttpResponseHeaders(Collections.emptyMap(), Collections.emptyMap()));
    private final HttpResponseHeaders responseHeaders;

    public Configuration(HttpResponseHeaders responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public HttpResponseHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public static class HttpResponseHeaders {
        private final Map<String, String> pages;
        private final Map<String, String> staticResources;

        public HttpResponseHeaders(Map<String, String> pages, Map<String, String> staticResources) {
            HashMap<String, String> pagesHttpHeaders = new HashMap<String, String>();
            pagesHttpHeaders.put("X-Content-Type-Options", "nosniff");
            pagesHttpHeaders.put("X-XSS-Protection", "1; mode=block");
            pagesHttpHeaders.put("Cache-Control", "no-store, no-cache, must-revalidate, private");
            pagesHttpHeaders.put("Expires", "0");
            pagesHttpHeaders.put("Pragma", "no-cache");
            pagesHttpHeaders.put("X-Frame-Options", "DENY");
            pagesHttpHeaders.putAll(pages);
            this.pages = Collections.unmodifiableMap(pagesHttpHeaders);
            HashMap<String, String> staticResourcesHttpHeaders = new HashMap<String, String>();
            staticResourcesHttpHeaders.put("Cache-Control", "public,max-age=2592000");
            staticResourcesHttpHeaders.putAll(staticResources);
            this.staticResources = Collections.unmodifiableMap(staticResourcesHttpHeaders);
        }

        public Map<String, String> forPages() {
            return this.pages;
        }

        public Map<String, String> forStaticResources() {
            return this.staticResources;
        }
    }
}

