/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class UriPatten
implements Comparable<UriPatten> {
    private static final Pattern URI_VARIABLE_PATTERN = Pattern.compile("\\{(.+?)\\}");
    private static final String URI_VARIABLE_REGEX = "([^/]+)";
    private static final String PLUS_MARKED_URI_VARIABLE_REGEX = "(.+)";
    private final String patternString;
    private final Pattern pattern;
    private final List<String> variableNames;

    public UriPatten(String uriPattern) {
        Pair<Boolean, List<String>> analyseResult = this.analyse(uriPattern);
        String indexPathRegex = null;
        if (uriPattern.endsWith("/index")) {
            uriPattern = uriPattern.substring(0, uriPattern.length() - "index".length());
            indexPathRegex = "(index)?";
        } else if (uriPattern.endsWith("/")) {
            indexPathRegex = "(index)?";
        }
        this.patternString = uriPattern;
        boolean hasPlusMarkedVariable = (Boolean)analyseResult.getLeft();
        this.variableNames = (List)analyseResult.getRight();
        String patternRegex = URI_VARIABLE_PATTERN.splitAsStream(uriPattern).map(Pattern::quote).collect(Collectors.joining(URI_VARIABLE_REGEX));
        if (uriPattern.charAt(uriPattern.length() - 1) == '}') {
            patternRegex = patternRegex + (hasPlusMarkedVariable ? PLUS_MARKED_URI_VARIABLE_REGEX : URI_VARIABLE_REGEX);
        }
        if (indexPathRegex != null) {
            patternRegex = patternRegex + indexPathRegex;
        }
        this.pattern = Pattern.compile(patternRegex);
    }

    private Pair<Boolean, List<String>> analyse(String uriPattern) {
        if (uriPattern.isEmpty()) {
            throw new IllegalArgumentException("URI pattern cannot be empty.");
        }
        if (uriPattern.charAt(0) != '/') {
            throw new IllegalArgumentException("URI patten must start with a '/'.");
        }
        int delta = 0;
        int currentVariableStartIndex = -1;
        boolean hasPlusMarkedVariable = false;
        ArrayList<String> variableNames = new ArrayList<String>();
        for (int i = 1; i < uriPattern.length(); ++i) {
            char currentChar = uriPattern.charAt(i);
            if (currentChar == '{') {
                if (++delta != 1) {
                    throw new IllegalArgumentException("Illegal URI variable opening '{' found at index " + i + " in URI pattern '" + uriPattern + "'. Cannot declare a variable inside another variable.");
                }
                currentVariableStartIndex = i + 1;
                continue;
            }
            if (currentChar == '}') {
                if (--delta != 0) {
                    throw new IllegalArgumentException("Illegal URI variable closing '}' found at index " + i + " in of URI pattern '" + uriPattern + "'. Cannot find matching opening.");
                }
                if (hasPlusMarkedVariable && i != uriPattern.length() - 1) {
                    throw new IllegalArgumentException("Illegal character found at index " + (i + 1) + " in URI pattern '" + uriPattern + "'. Cannot have any more characters after enclosing a 'one or more matching' type URI variable declaration.");
                }
                variableNames.add(uriPattern.substring(currentVariableStartIndex, i));
                continue;
            }
            if (currentChar != '+' || delta != 1 || uriPattern.charAt(i - 1) != '{') continue;
            ++currentVariableStartIndex;
            hasPlusMarkedVariable = true;
        }
        if (delta > 0) {
            throw new IllegalArgumentException("Illegal URI variable opening '{' found at index " + (currentVariableStartIndex - 1) + " in URI pattern '" + uriPattern + "' which was never closed.");
        }
        return Pair.of((Object)hasPlusMarkedVariable, variableNames);
    }

    public boolean matches(String uri) {
        return this.pattern.matcher(uri).matches();
    }

    public Optional<Map<String, String>> match(String uri) {
        Matcher matcher = this.pattern.matcher(uri);
        if (matcher.matches()) {
            if (!this.variableNames.isEmpty()) {
                HashMap<String, String> result = new HashMap<String, String>(this.variableNames.size());
                for (int i = 0; i < this.variableNames.size(); ++i) {
                    String name = this.variableNames.get(i);
                    String value = matcher.group(i + 1);
                    result.put(name, value);
                }
                return Optional.of(result);
            }
            return Optional.of(Collections.emptyMap());
        }
        return Optional.empty();
    }

    @Override
    public int compareTo(UriPatten otherUriPattern) {
        if (otherUriPattern == null) {
            return 1;
        }
        String[] a = URI_VARIABLE_PATTERN.split(this.patternString);
        String[] b = URI_VARIABLE_PATTERN.split(otherUriPattern.patternString);
        for (int i = 0; i < Math.min(a.length, b.length); ++i) {
            int bLen;
            int aLen = a[i].length();
            if (aLen == (bLen = b[i].length())) continue;
            return bLen - aLen;
        }
        if (a.length == b.length) {
            return this.patternString.compareTo(otherUriPattern.patternString);
        }
        return b.length - a.length;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof UriPatten && this.compareTo((UriPatten)obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.patternString, this.pattern);
    }

    public String toString() {
        return "UriPatten{patternString='" + this.patternString + "', pattern=" + this.pattern + "'}";
    }
}

