/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api.http;

import java.util.List;
import java.util.Map;

public interface HttpRequest {
    public String getMethod();

    public String getProtocol();

    public boolean isSecure();

    default public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public String getUrl();

    public String getUri();

    public String getContextPath();

    public String getUriWithoutContextPath();

    public String getQueryString();

    public Map<String, List<String>> getQueryParams();

    public Map<String, String> getHeaders();

    public String getCookieValue(String var1);

    public String toString();

    default public boolean isValid() {
        String uri = this.getUri();
        if (uri == null || uri.length() < 2 || uri.charAt(0) != '/') {
            return false;
        }
        boolean isPreviousCharInvalid = false;
        for (int i = 0; i < uri.length(); ++i) {
            char currentChar = uri.charAt(i);
            if (currentChar == '/' || currentChar == '.') {
                if (isPreviousCharInvalid) {
                    return false;
                }
                isPreviousCharInvalid = true;
                continue;
            }
            isPreviousCharInvalid = false;
        }
        return true;
    }

    default public boolean isStaticResourceRequest() {
        return this.getUriWithoutContextPath().startsWith("/public/");
    }

    default public boolean isAppStaticResourceRequest() {
        return this.getUriWithoutContextPath().startsWith("/public/app/");
    }

    default public boolean isExtensionStaticResourceRequest() {
        return this.getUriWithoutContextPath().startsWith("/public/extensions/");
    }

    default public boolean isThemeStaticResourceRequest() {
        return this.getUriWithoutContextPath().startsWith("/public/themes/");
    }

    default public boolean isDefaultFaviconRequest() {
        return this.getUri().equals("/favicon.ico");
    }

    public static String getContextPath(String uri) {
        int secondSlash = uri.indexOf(47, 1);
        if (secondSlash == -1) {
            return uri;
        }
        return uri.substring(0, secondSlash);
    }

    public static String getUriWithoutContextPath(String uri) {
        int secondSlash = uri.indexOf(47, 1);
        if (secondSlash == -1) {
            return "";
        }
        return uri.substring(secondSlash, uri.length());
    }
}

