/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.wso2.carbon.uiserver.api.App;

public class AppRegistry {
    private final Map<String, App> apps = new HashMap<String, App>();

    public String add(App app) {
        String key = AppRegistry.keyFor(app);
        this.apps.put(key, app);
        return key;
    }

    public Optional<App> get(String key) {
        return Optional.ofNullable(this.apps.get(key));
    }

    public Collection<App> getAll() {
        return this.apps.values();
    }

    public Optional<App> remove(String key) {
        return Optional.ofNullable(this.apps.remove(key));
    }

    public boolean remove(App app) {
        return this.apps.remove(AppRegistry.keyFor(app)) != null;
    }

    public Optional<App> find(Predicate<App> predicate) {
        return this.apps.values().stream().filter(predicate).findFirst();
    }

    public void clear() {
        this.apps.clear();
    }

    private static String keyFor(App app) {
        return app.getName() + app.getPaths();
    }
}

