/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment.listener;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.api.ServerConfiguration;
import org.wso2.carbon.uiserver.internal.deployment.AppDeploymentEventListener;
import org.wso2.carbon.uiserver.internal.deployment.msf4j.MicroserviceRegistration;
import org.wso2.carbon.uiserver.internal.deployment.msf4j.MicroservicesRegistrar;
import org.wso2.carbon.uiserver.internal.deployment.msf4j.WebappMicroservice;
import org.wso2.carbon.uiserver.internal.exception.AppDeploymentEventListenerException;
import org.wso2.carbon.uiserver.internal.http.RequestDispatcher;
import org.wso2.msf4j.Microservice;

public class AppTransportBinder
implements AppDeploymentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppTransportBinder.class);
    private final MicroservicesRegistrar microservicesRegistrar;
    private final ConcurrentMap<String, Set<MicroserviceRegistration>> microserviceRegistrations;
    private final ServerConfiguration serverConfiguration;

    public AppTransportBinder(MicroservicesRegistrar microservicesRegistrar, ServerConfiguration serverConfiguration) {
        this.microservicesRegistrar = microservicesRegistrar;
        this.microserviceRegistrations = new ConcurrentHashMap<String, Set<MicroserviceRegistration>>();
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    public void appDeploymentEvent(App app) throws AppDeploymentEventListenerException {
        String appName = app.getName();
        String appContextPath = app.getContextPath();
        WebappMicroservice microservice = AppTransportBinder.createMicroservice(app);
        String transportId = this.serverConfiguration.getConfigurationForApp(appName).flatMap(ServerConfiguration.AppConfiguration::getTransportId).orElse(null);
        if (transportId == null) {
            Set<MicroserviceRegistration> registrations = this.microservicesRegistrar.register(microservice, appContextPath);
            if (registrations.isEmpty()) {
                throw new AppDeploymentEventListenerException("Cannot find any HTTPS transports to register web app '" + appName + "'.");
            }
            this.microserviceRegistrations.put(appName, registrations);
            registrations.stream().map(registration -> registration.getRegisteredHttpTransport().getUrlFor(appContextPath)).forEach(appUrl -> LOGGER.info("Web app '{}' is available at '{}'.", (Object)appName, appUrl));
        } else {
            MicroserviceRegistration registration2;
            try {
                registration2 = this.microservicesRegistrar.register((Microservice)microservice, appContextPath, transportId);
            }
            catch (IllegalArgumentException e) {
                throw new AppDeploymentEventListenerException("Cannot find a configured HTTP transport for ID '" + transportId + "' to register web app '" + appName + "'.", e);
            }
            this.microserviceRegistrations.put(appName, Collections.singleton(registration2));
            LOGGER.info("Web app '{}' is available at '{}'.", (Object)appName, (Object)registration2.getRegisteredHttpTransport().getUrlFor(appContextPath));
        }
    }

    @Override
    public void appUndeploymentEvent(String appName) throws AppDeploymentEventListenerException {
        Set microserviceRegistrations = (Set)this.microserviceRegistrations.remove(appName);
        if (microserviceRegistrations == null) {
            throw new AppDeploymentEventListenerException("Cannot unregister web app '" + appName + "'. App might be already unregistered or not be registered at all.");
        }
        microserviceRegistrations.forEach(microserviceRegistration -> {
            microserviceRegistration.unregister();
            LOGGER.debug("Web app '{}' unregistered from {}.", (Object)appName, (Object)microserviceRegistration.getRegisteredHttpTransport());
        });
        LOGGER.info("Web app '{}' undeployed.", (Object)appName);
    }

    public void close() {
        for (Set microserviceRegistration : this.microserviceRegistrations.values()) {
            microserviceRegistration.forEach(MicroserviceRegistration::unregister);
        }
        this.microserviceRegistrations.clear();
    }

    private static WebappMicroservice createMicroservice(App app) {
        RequestDispatcher requestDispatcher = new RequestDispatcher(app);
        return new WebappMicroservice(requestDispatcher::serve);
    }
}

