/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment.listener;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.internal.deployment.AppDeploymentEventListener;
import org.wso2.carbon.uiserver.spi.Server;

public class CarbonUiServer
implements Server,
AppDeploymentEventListener {
    private final ConcurrentMap<String, App> deployedApps = new ConcurrentHashMap<String, App>();

    @Override
    public Optional<App> getApp(String appName) {
        return Optional.ofNullable(this.deployedApps.get(appName));
    }

    @Override
    public void appDeploymentEvent(App app) {
        this.deployedApps.put(app.getName(), app);
    }

    @Override
    public void appUndeploymentEvent(String appName) {
        this.deployedApps.remove(appName);
    }

    public void close() {
        this.deployedApps.clear();
    }
}

