/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment.listener;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.api.ServerConfiguration;
import org.wso2.carbon.uiserver.internal.deployment.AppDeploymentEventListener;
import org.wso2.carbon.uiserver.internal.deployment.msf4j.MicroserviceRegistration;
import org.wso2.carbon.uiserver.internal.deployment.msf4j.MicroservicesRegistrar;
import org.wso2.carbon.uiserver.internal.exception.AppDeploymentEventListenerException;
import org.wso2.carbon.uiserver.spi.RestApiProvider;
import org.wso2.msf4j.Microservice;

public class RestApiDeployer
implements AppDeploymentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestApiDeployer.class);
    private final MicroservicesRegistrar microservicesRegistrar;
    private final SetMultimap<String, RestApiProvider> restApiProviders;
    private final ServerConfiguration serverConfiguration;
    private final ConcurrentMap<String, Set<MicroserviceRegistration>> microserviceRegistrations;

    public RestApiDeployer(Set<RestApiProvider> restApiProviders, MicroservicesRegistrar microservicesRegistrar, ServerConfiguration serverConfiguration) {
        this.microservicesRegistrar = microservicesRegistrar;
        this.restApiProviders = (SetMultimap)restApiProviders.stream().collect(Multimaps.toMultimap(RestApiProvider::getAppName, Function.identity(), HashMultimap::create));
        this.serverConfiguration = serverConfiguration;
        this.microserviceRegistrations = new ConcurrentHashMap<String, Set<MicroserviceRegistration>>();
    }

    @Override
    public void appDeploymentEvent(App app) throws AppDeploymentEventListenerException {
        String appName = app.getName();
        Set restApiProviders = this.restApiProviders.get((Object)appName);
        if (restApiProviders == null) {
            LOGGER.debug("Web app '{}' does not have any REST APIs provider registered for it.", (Object)appName);
            return;
        }
        Map<String, Microservice> microservices = this.collectMicroservices(restApiProviders, app);
        String transportId = this.serverConfiguration.getConfigurationForApp(appName).flatMap(ServerConfiguration.AppConfiguration::getTransportId).orElse(null);
        Set microserviceRegistrations = transportId == null ? microservices.entrySet().stream().map(entry -> this.registerMicroservice((Microservice)entry.getValue(), (String)entry.getKey())).flatMap(Collection::stream).collect(Collectors.toSet()) : microservices.entrySet().stream().map(entry -> this.registerMicroservice((Microservice)entry.getValue(), (String)entry.getKey(), transportId)).collect(Collectors.toSet());
        this.microserviceRegistrations.put(appName, microserviceRegistrations);
    }

    @Override
    public void appUndeploymentEvent(String appName) throws AppDeploymentEventListenerException {
        Set microserviceRegistrations = (Set)this.microserviceRegistrations.remove(appName);
        if (microserviceRegistrations != null) {
            microserviceRegistrations.forEach(MicroserviceRegistration::unregister);
            microserviceRegistrations.clear();
        }
    }

    public void close() {
        for (Set registrations : this.microserviceRegistrations.values()) {
            registrations.forEach(MicroserviceRegistration::unregister);
            registrations.clear();
        }
        this.microserviceRegistrations.clear();
        this.restApiProviders.clear();
    }

    private Map<String, Microservice> collectMicroservices(Set<RestApiProvider> restApiProviders, App app) {
        HashMap<String, Microservice> allMicroservices = new HashMap<String, Microservice>();
        for (RestApiProvider restApiProvider : restApiProviders) {
            Map<String, Microservice> microservices = restApiProvider.getMicroservices(app);
            for (Map.Entry<String, Microservice> entry : microservices.entrySet()) {
                String contextPath = entry.getKey();
                if (contextPath == null || contextPath.isEmpty() || contextPath.charAt(0) != '/') {
                    throw new AppDeploymentEventListenerException("Invalid context path '" + contextPath + "'returned for a REST API by REST API Provider '" + restApiProvider + "' for app '" + app.getName() + "'. Context path should be a nun-null, non-empty, and should start with a '/'.");
                }
                Microservice microservice = entry.getValue();
                if (microservice == null) {
                    throw new AppDeploymentEventListenerException("Cannot register null Microservice to context path '" + contextPath + "' for app '" + app.getName() + "'.");
                }
                allMicroservices.put(app.getContextPath() + contextPath, microservice);
            }
        }
        return allMicroservices;
    }

    private Set<MicroserviceRegistration> registerMicroservice(Microservice microservice, String contextPath) {
        Set<MicroserviceRegistration> registrations = this.microservicesRegistrar.register(microservice, contextPath);
        if (registrations.isEmpty()) {
            throw new AppDeploymentEventListenerException("Cannot find any HTTPS transports to register Microservice " + microservice + " as a REST API to context path '" + contextPath + "'.");
        }
        for (MicroserviceRegistration registration : registrations) {
            LOGGER.debug("Microservice '{}' is available as a HTTPS REST API at '{}'.", (Object)microservice, (Object)registration.getRegisteredHttpTransport().getUrlFor(contextPath));
        }
        return registrations;
    }

    private MicroserviceRegistration registerMicroservice(Microservice microservice, String contextPath, String transportId) {
        MicroserviceRegistration microserviceRegistration;
        try {
            microserviceRegistration = this.microservicesRegistrar.register(microservice, contextPath, transportId);
        }
        catch (IllegalArgumentException e) {
            throw new AppDeploymentEventListenerException("Cannot find a configured HTTP transport for ID '" + transportId + "' to deploy REST APIs.");
        }
        LOGGER.debug("Microservice '{}' is available as a HTTP REST API at '{}'.", (Object)microservice, (Object)microserviceRegistration.getRegisteredHttpTransport().getUrlFor(contextPath));
        return microserviceRegistration;
    }
}

