/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.api.exception.UiServerRuntimeException;
import org.wso2.carbon.uiserver.api.http.HttpRequest;
import org.wso2.carbon.uiserver.api.http.HttpResponse;
import org.wso2.carbon.uiserver.internal.http.PageRequestDispatcher;
import org.wso2.carbon.uiserver.internal.http.ResponseBuilder;
import org.wso2.carbon.uiserver.internal.io.http.StaticRequestDispatcher;

public class RequestDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestDispatcher.class);
    private final PageRequestDispatcher pageRequestDispatcher;
    private final StaticRequestDispatcher staticRequestDispatcher;

    public RequestDispatcher(App app) {
        this(new PageRequestDispatcher(app), new StaticRequestDispatcher(app));
    }

    RequestDispatcher(PageRequestDispatcher pageRequestDispatcher, StaticRequestDispatcher staticRequestDispatcher) {
        this.pageRequestDispatcher = pageRequestDispatcher;
        this.staticRequestDispatcher = staticRequestDispatcher;
    }

    public HttpResponse serve(HttpRequest request) {
        if (!request.isValid()) {
            return ResponseBuilder.badRequest("URI '" + request.getUri() + "' is invalid.").build();
        }
        try {
            if (request.isDefaultFaviconRequest()) {
                return this.staticRequestDispatcher.serveDefaultFavicon(request);
            }
            if (request.isStaticResourceRequest()) {
                return this.staticRequestDispatcher.serve(request);
            }
            return this.pageRequestDispatcher.serve(request);
        }
        catch (UiServerRuntimeException e) {
            LOGGER.error("An error occurred when serving for request '{}'.", (Object)request, (Object)e);
            return ResponseBuilder.serverError("A server error occurred while serving for request.").build();
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred when serving for request '{}'.", (Object)request, (Object)e);
            return ResponseBuilder.serverError("An unexpected server error occurred while serving for request.").build();
        }
    }
}

