/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.http;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.uiserver.api.http.HttpResponse;

public class ResponseBuilder {
    private int status;
    private Object content;
    private String contentType;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> cookies = new HashMap<String, String>();

    public ResponseBuilder statusCode(int status) {
        this.status = status;
        return this;
    }

    public ResponseBuilder content(Object content) {
        this.content = content;
        return this;
    }

    public ResponseBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ResponseBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public ResponseBuilder headers(Map<String, String> headers) {
        headers.forEach(this::header);
        return this;
    }

    public ResponseBuilder cookie(String name, String value) {
        this.cookies.put(name, value);
        return this;
    }

    public ResponseBuilder cookies(Map<String, String> cookies) {
        cookies.forEach(this::cookie);
        return this;
    }

    public HttpResponse build() {
        return new HttpResponse(this.status, this.content, this.contentType, this.headers, this.cookies);
    }

    public static ResponseBuilder status(int status) {
        return new ResponseBuilder().statusCode(status);
    }

    public static ResponseBuilder ok() {
        return ResponseBuilder.status(200);
    }

    public static ResponseBuilder ok(String content) {
        return ResponseBuilder.ok(content, "text/plain");
    }

    public static ResponseBuilder ok(String content, String contentType) {
        return ResponseBuilder.ok().content(content).contentType(contentType);
    }

    public static ResponseBuilder ok(File content, String contentType) {
        return ResponseBuilder.ok().content(content).contentType(contentType);
    }

    public static ResponseBuilder ok(Path content, String contentType) {
        return ResponseBuilder.ok(content.toFile(), contentType);
    }

    public static ResponseBuilder ok(InputStream content, String contentType) {
        return ResponseBuilder.ok().content(content).contentType(contentType);
    }

    public static ResponseBuilder badRequest() {
        return ResponseBuilder.status(400);
    }

    public static ResponseBuilder badRequest(String content) {
        return ResponseBuilder.badRequest().content(content).contentType("text/plain");
    }

    public static ResponseBuilder notFound() {
        return ResponseBuilder.status(404);
    }

    public static ResponseBuilder notFound(String content) {
        return ResponseBuilder.notFound().content(content).contentType("text/plain");
    }

    public static ResponseBuilder serverError() {
        return ResponseBuilder.status(500);
    }

    public static ResponseBuilder serverError(String content) {
        return ResponseBuilder.serverError().content(content).contentType("text/plain");
    }
}

