/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.http.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpAddressUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpAddressUtils.class);
    private static String localInternetAddress;

    public static Optional<String> getLocalIpAddress() {
        block5: {
            if (localInternetAddress != null) {
                return Optional.of(localInternetAddress);
            }
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                        localInternetAddress = inetAddress.getHostAddress();
                        break block5;
                    }
                }
            }
            catch (SocketException e) {
                LOGGER.debug("Cannot access information on network interfaces.", (Throwable)e);
            }
        }
        return Optional.ofNullable(localInternetAddress);
    }
}

