/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.impl;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.wso2.carbon.uiserver.api.Configuration;
import org.wso2.carbon.uiserver.api.Page;
import org.wso2.carbon.uiserver.api.UriPatten;
import org.wso2.carbon.uiserver.api.exception.RenderingException;
import org.wso2.carbon.uiserver.api.http.HttpRequest;
import org.wso2.carbon.uiserver.internal.exception.AppCreationException;
import org.wso2.carbon.uiserver.internal.exception.FileOperationException;

public class HbsPage
extends Page {
    private static final Handlebars HANDLEBARS = new Handlebars();
    private final Template template;

    public HbsPage(UriPatten uriPatten, String template) {
        super(uriPatten);
        this.template = HbsPage.compile(template);
    }

    @Override
    public String render(HttpRequest request, Configuration configuration) throws RenderingException {
        Map<String, String> model = Collections.singletonMap("@contextPath", request.getContextPath());
        Context context = Context.newContext(model);
        try {
            return this.template.apply(context);
        }
        catch (IOException e) {
            throw new RenderingException("Cannot load page Handlebars template.", e);
        }
        catch (HandlebarsException e) {
            throw new RenderingException("Cannot render page Handlebars template.", e);
        }
    }

    private static Template compile(String template) {
        try {
            return HANDLEBARS.compileInline(template);
        }
        catch (IOException e) {
            throw new FileOperationException("Cannot load Handlebars template.", e);
        }
        catch (HandlebarsException e) {
            throw new AppCreationException("Cannot compile Handlebars template.", e);
        }
    }
}

