/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.api.Configuration;
import org.wso2.carbon.uiserver.api.Extension;
import org.wso2.carbon.uiserver.api.I18nResource;
import org.wso2.carbon.uiserver.api.Page;
import org.wso2.carbon.uiserver.api.Theme;

public class OverriddenApp
extends App {
    private final App base;
    private final App override;

    public OverriddenApp(App base, App override) {
        super(override.getName(), override.getContextPath(), OverriddenApp.getPagesFrom(base, override), OverriddenApp.getExtensionsFrom(base, override), OverriddenApp.getThemesFrom(base, override), OverriddenApp.getI18nResourcesFrom(base, override), OverriddenApp.getConfigurationFrom(base, override), OverriddenApp.getPathsFrom(base, override));
        this.base = base;
        this.override = override;
    }

    @Override
    public App getBase() {
        return this.base;
    }

    @Override
    public Optional<App> getOverride() {
        return Optional.of(this.override);
    }

    private static SortedSet<Page> getPagesFrom(App base, App override) {
        TreeSet<Page> pages = new TreeSet<Page>(OverriddenApp.getPagesOf(override));
        pages.addAll(OverriddenApp.getPagesOf(base));
        return pages;
    }

    private static Set<Extension> getExtensionsFrom(App base, App override) {
        Function<Extension, String> getKey = extension -> extension.getType() + extension.getName();
        Map extensions = OverriddenApp.getExtensionsOf(base).stream().collect(Collectors.toMap(getKey, Function.identity()));
        for (Extension extension2 : OverriddenApp.getExtensionsOf(override)) {
            extensions.merge(getKey.apply(extension2), extension2, Extension::override);
        }
        return new HashSet<Extension>(extensions.values());
    }

    private static Set<Theme> getThemesFrom(App base, App override) {
        Map themes = OverriddenApp.getThemesOf(base).stream().collect(Collectors.toMap(Theme::getName, Function.identity()));
        for (Theme theme : OverriddenApp.getThemesOf(override)) {
            themes.merge(theme.getName(), theme, Theme::override);
        }
        return new HashSet<Theme>(themes.values());
    }

    private static Set<I18nResource> getI18nResourcesFrom(App base, App override) {
        return ImmutableSet.builder().addAll(OverriddenApp.getI18nResourcesOf(override)).addAll(OverriddenApp.getI18nResourcesOf(base)).build();
    }

    private static Configuration getConfigurationFrom(App base, App override) {
        return Objects.equals(override.getConfiguration(), Configuration.DEFAULT_CONFIGURATION) ? base.getConfiguration() : override.getConfiguration();
    }

    private static List<String> getPathsFrom(App base, App override) {
        return ImmutableList.builder().addAll(override.getPaths()).addAll(base.getPaths()).build();
    }
}

