/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.io.reference;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.wso2.carbon.uiserver.internal.exception.FileOperationException;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactExtensionReference;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactFileReference;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactI18nResourceReference;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactPageReference;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactThemeReference;
import org.wso2.carbon.uiserver.internal.io.util.PathUtils;
import org.wso2.carbon.uiserver.internal.reference.AppReference;
import org.wso2.carbon.uiserver.internal.reference.ExtensionReference;
import org.wso2.carbon.uiserver.internal.reference.FileReference;
import org.wso2.carbon.uiserver.internal.reference.I18nResourceReference;
import org.wso2.carbon.uiserver.internal.reference.PageReference;
import org.wso2.carbon.uiserver.internal.reference.ThemeReference;

public class ArtifactAppReference
implements AppReference {
    private final Path appDirectory;

    public ArtifactAppReference(Path appDirectory) {
        this.appDirectory = appDirectory.normalize().toAbsolutePath();
    }

    @Override
    public String getName() throws FileOperationException {
        return PathUtils.getName(this.appDirectory);
    }

    @Override
    public Set<PageReference> getPageReferences() throws FileOperationException {
        Path pages = this.getPagesDirectory();
        if (!Files.exists(pages, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try {
            return Files.walk(pages, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(pageFile -> new ArtifactPageReference((Path)pageFile, this)).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new FileOperationException("An error occurred while listing pages in '" + pages + "'.", e);
        }
    }

    @Override
    public Set<ExtensionReference> getExtensionReferences() throws FileOperationException {
        Path extensions = this.appDirectory.resolve("extensions");
        if (!Files.exists(extensions, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try {
            return Files.list(extensions).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(extensionType -> {
                try {
                    return Files.list(extensionType).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(ArtifactExtensionReference::new);
                }
                catch (IOException e) {
                    throw new FileOperationException("An error occurred while listing extensions in '" + extensionType + "'.", e);
                }
            }).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new FileOperationException("An error occurred while listing extension types '" + extensions + "'.", e);
        }
    }

    @Override
    public Set<ThemeReference> getThemeReferences() throws FileOperationException {
        Path themes = this.appDirectory.resolve("themes");
        if (!Files.exists(themes, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try {
            return Files.list(themes).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(ArtifactThemeReference::new).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new FileOperationException("An error occurred while listing themes in '" + themes + "'.", e);
        }
    }

    @Override
    public Set<I18nResourceReference> getI18nResourceReferences() throws FileOperationException {
        Path lang = this.appDirectory.resolve("i18n");
        if (!Files.exists(lang, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try {
            return Files.list(lang).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && "json".equals(PathUtils.getExtension(path))).map(ArtifactI18nResourceReference::new).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new FileOperationException("An error occurred while listing i18n files in '" + lang + "'.", e);
        }
    }

    @Override
    public Optional<FileReference> getConfiguration() throws FileOperationException {
        Path configuration = this.appDirectory.resolve("configuration.yaml");
        return Files.exists(configuration, new LinkOption[0]) ? Optional.of(new ArtifactFileReference(configuration)) : Optional.empty();
    }

    @Override
    public String getPath() throws FileOperationException {
        return this.appDirectory.toString();
    }

    Path getPagesDirectory() {
        return this.appDirectory.resolve("pages");
    }
}

