/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.io.reference;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.wso2.carbon.uiserver.internal.exception.FileOperationException;
import org.wso2.carbon.uiserver.internal.io.util.PathUtils;
import org.wso2.carbon.uiserver.internal.reference.FileReference;

public class ArtifactFileReference
implements FileReference {
    private final Path filePath;

    public ArtifactFileReference(Path filePath) {
        this.filePath = filePath;
    }

    @Override
    public String getName() throws FileOperationException {
        return PathUtils.getName(this.filePath);
    }

    @Override
    public String getExtension() throws FileOperationException {
        return PathUtils.getExtension(this.filePath);
    }

    @Override
    public String getContent() throws FileOperationException {
        try {
            return new String(Files.readAllBytes(this.filePath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FileOperationException("Cannot read content of file '" + this.filePath + "'.", e);
        }
    }

    @Override
    public String getFilePath() throws FileOperationException {
        return this.filePath.toString();
    }
}

