/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.io.reference;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import org.wso2.carbon.uiserver.internal.exception.FileOperationException;
import org.wso2.carbon.uiserver.internal.io.util.PathUtils;
import org.wso2.carbon.uiserver.internal.reference.I18nResourceReference;

public class ArtifactI18nResourceReference
implements I18nResourceReference {
    public static final String I18N_RESOURCE_FILE_EXTENSION = "json";
    private static final Gson GSON = new Gson();
    private static final Type GSON_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private final Path messagesFile;

    public ArtifactI18nResourceReference(Path messagesFile) {
        this.messagesFile = messagesFile;
    }

    @Override
    public Locale getLocale() throws FileOperationException {
        return Locale.forLanguageTag(PathUtils.getExtension(this.messagesFile));
    }

    @Override
    public Map<String, String> getMessages() throws FileOperationException {
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(this.messagesFile, StandardCharsets.UTF_8);
            return (Map)GSON.fromJson((Reader)bufferedReader, GSON_TYPE);
        }
        catch (IOException e) {
            throw new FileOperationException("Cannot read content of i18n message file '" + this.messagesFile + "'.");
        }
        catch (JsonParseException e) {
            throw new FileOperationException("I18n message file '" + this.messagesFile + "' is not a valid JSON.");
        }
    }
}

