/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.util.concurrent.TimeUnit;

public interface ClockSource {
    public static final ClockSource INSTANCE = Factory.access$000();

    public long currentTime();

    public long toMillis(long var1);

    public long elapsedMillis(long var1);

    public long elapsedMillis(long var1, long var3);

    public long plusMillis(long var1, long var3);

    public static final class NanosecondClockSource
    implements ClockSource {
        @Override
        public long currentTime() {
            return System.nanoTime();
        }

        @Override
        public final long toMillis(long time) {
            return TimeUnit.NANOSECONDS.toMillis(time);
        }

        @Override
        public long elapsedMillis(long startTime) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        }

        @Override
        public long elapsedMillis(long startTime, long endTime) {
            return TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
        }

        @Override
        public long plusMillis(long time, long millis) {
            return time + TimeUnit.MILLISECONDS.toNanos(millis);
        }
    }

    public static final class MillisecondClockSource
    implements ClockSource {
        @Override
        public long currentTime() {
            return System.currentTimeMillis();
        }

        @Override
        public long elapsedMillis(long startTime) {
            return System.currentTimeMillis() - startTime;
        }

        @Override
        public long elapsedMillis(long startTime, long endTime) {
            return endTime - startTime;
        }

        @Override
        public long toMillis(long time) {
            return time;
        }

        @Override
        public long plusMillis(long time, long millis) {
            return time + millis;
        }
    }

    public static class Factory {
        private static ClockSource create() {
            String os = System.getProperty("os.name");
            if ("Mac OS X".equals(os)) {
                return new MillisecondClockSource();
            }
            return new NanosecondClockSource();
        }

        static /* synthetic */ ClockSource access$000() {
            return Factory.create();
        }
    }
}

