/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.context;

import java.security.Principal;
import org.slf4j.MDC;
import org.wso2.carbon.kernel.context.CarbonContext;
import org.wso2.carbon.kernel.internal.context.CarbonContextHolder;
import org.wso2.carbon.utils.Utils;

public final class PrivilegedCarbonContext
extends CarbonContext {
    private PrivilegedCarbonContext(CarbonContextHolder carbonContextHolder) {
        super(carbonContextHolder);
    }

    public static PrivilegedCarbonContext getCurrentContext() {
        Utils.checkSecurity();
        return new PrivilegedCarbonContext(CarbonContextHolder.getCurrentContextHolder());
    }

    public static void destroyCurrentContext() {
        Utils.checkSecurity();
        PrivilegedCarbonContext.getCurrentContext().getCarbonContextHolder().destroyCurrentCarbonContextHolder();
    }

    public void setUserPrincipal(Principal userPrincipal) {
        Utils.checkSecurity();
        this.getCarbonContextHolder().setUserPrincipal(userPrincipal);
        MDC.put((String)"user-name", (String)userPrincipal.getName());
    }

    public void setProperty(String name, Object value) {
        Utils.checkSecurity();
        this.getCarbonContextHolder().setProperty(name, value);
    }
}

