/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.CapabilityProviderCapability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.StartupComponent;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

class StartupComponentManager {
    private static final Logger logger = LoggerFactory.getLogger(StartupComponentManager.class);
    private Map<String, StartupComponent> startupComponentMap = new HashMap<String, StartupComponent>();

    StartupComponentManager() {
    }

    void addStartupComponent(StartupComponent startupComponent) {
        String componentName = startupComponent.getName();
        if (this.startupComponentMap.get(componentName) != null) {
            StartupComponent existingComponent = this.startupComponentMap.get(componentName);
            logger.warn("Duplicate Startup-Component detected. Existing Startup-Component {} from bundle({}:{}). New Startup-Component {} from bundle({}:{}).", new Object[]{existingComponent.getName(), existingComponent.getBundle().getSymbolicName(), existingComponent.getBundle().getVersion(), startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding startup component {} from bundle({}:{})", new Object[]{componentName, startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
        }
        this.startupComponentMap.put(componentName, startupComponent);
    }

    void addRequiredOSGiServiceToComponent(String componentName, String capabilityName) {
        StartupComponent startupComponent = this.startupComponentMap.get(componentName);
        if (startupComponent == null) {
            logger.warn("Adding a required OSGi service capability to component, but specified startup component is not available, component-name: {} and capability-name: {}.", (Object)componentName, (Object)capabilityName);
            return;
        }
        logger.debug("Updating the required OSGi Service list of startup component {}. capabilityName: {} ", (Object)componentName, (Object)capabilityName);
        startupComponent.addRequiredService(capabilityName);
    }

    void addRequiredCapabilityListener(RequiredCapabilityListener listener, String componentName, Bundle bundle) {
        StartupComponent startupComponent = this.startupComponentMap.get(componentName);
        if (startupComponent == null) {
            logger.warn("Adding a RequiredCapabilityListener from bundle({}:{}), but specified startup component is not available, component-name: {}", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), componentName});
            return;
        }
        if (startupComponent.getListener() != null) {
            logger.warn("Duplicate RequiredCapabilityListener detected. Existing RequiredCapabilityListener for startup component {}. New RequiredCapabilityListener from bundle({}:{}).", new Object[]{componentName, bundle.getSymbolicName(), bundle.getVersion()});
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding available RequiredCapabilityListener with the componentName {} from bundle({}:{})", new Object[]{componentName, bundle.getSymbolicName(), bundle.getVersion()});
        }
        startupComponent.setListener(listener);
    }

    void addExpectedOrAvailableCapabilityProvider(CapabilityProviderCapability capabilityProvider) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding expected CapabilityProvider with the CapabilityName {} from bundle({}:{})", new Object[]{capabilityProvider.getProvidedCapabilityName(), capabilityProvider.getBundle().getSymbolicName(), capabilityProvider.getBundle().getVersion()});
        }
        this.startupComponentMap.values().stream().filter(startupComponent -> startupComponent.isServiceRequired(capabilityProvider.getProvidedCapabilityName())).forEach(startupComponent -> startupComponent.addExpectedOrAvailableCapabilityProvider(capabilityProvider));
    }

    void addExpectedCapability(Capability capability) {
        this.startupComponentMap.values().stream().filter(startupComponent -> startupComponent.isServiceRequired(capability.getName())).forEach(startupComponent -> {
            if (startupComponent.isSatisfied()) {
                logger.warn("You are trying to add an {} capability {} from bundle({}:{}) to an already activated startup listener component {} in bundle({}:{}). Refer the Startup Order Resolver documentation and verify your configuration", new Object[]{capability.getState(), capability.getName(), capability.getBundle().getSymbolicName(), capability.getBundle().getVersion(), startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Adding {} required capability {} from bundle({}:{}) to startup listener component {}.", new Object[]{capability.getState(), capability.getName(), capability.getBundle().getSymbolicName(), capability.getBundle().getVersion(), startupComponent.getName()});
            }
            startupComponent.addExpectedCapability(new Capability(capability));
        });
    }

    void updateCapability(Capability capability) {
        this.startupComponentMap.values().stream().filter(startupComponent -> startupComponent.isServiceRequired(capability.getName())).forEach(startupComponent -> {
            if (startupComponent.isSatisfied()) {
                logger.warn("You are trying to add an {} capability {} from bundle({}:{}) to an already satisfied startup listener component {} in bundle({}:{}). Either specify the capability in the Carbon-Component manifest header or explicitly skip the Startup Order Resolver. Refer the Startup Order Resolver documentation for more information.", new Object[]{capability.getState(), capability.getName(), capability.getBundle().getSymbolicName(), capability.getBundle().getVersion(), startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
            }
            startupComponent.updateCapability(capability);
        });
    }

    List<StartupComponent> getComponents(Predicate<StartupComponent> componentFilter) {
        return this.startupComponentMap.values().stream().filter(componentFilter).collect(Collectors.toList());
    }

    List<CapabilityProviderCapability> getPendingCapabilityProviders() {
        return this.startupComponentMap.values().stream().filter(StartupComponent::isPending).flatMap(startupComponent -> startupComponent.getPendingCapabilityProviders().stream()).distinct().collect(Collectors.toList());
    }

    void notifySatisfiableComponents() {
        this.getComponents(StartupComponent::isSatisfiable).forEach(startupComponent -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying RequiredCapabilityListener of component {} from bundle({}:{}) since all the required capabilities are available", new Object[]{startupComponent.getName(), startupComponent.getBundle().getSymbolicName(), startupComponent.getBundle().getVersion()});
            }
            startupComponent.setSatisfied(true);
            RequiredCapabilityListener capabilityListener = startupComponent.getListener();
            try {
                capabilityListener.onAllRequiredCapabilitiesAvailable();
            }
            catch (RuntimeException e) {
                logger.error("Runtime Exception occurred while calling onAllRequiredCapabilitiesAvailable of component " + startupComponent.getName(), (Throwable)e);
            }
        });
    }
}

