/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final String PROJECT_DEFAULTS_PROPERTY_FILE = "project.defaults.properties";

    private Utils() {
    }

    public static Path getCarbonYAMLLocation() {
        return Paths.get(org.wso2.carbon.utils.Utils.getCarbonConfigHome().toString(), "carbon.yaml");
    }

    public static Properties loadProjectProperties() {
        Properties properties = new Properties();
        try (InputStream in = Utils.class.getClassLoader().getResourceAsStream(PROJECT_DEFAULTS_PROPERTY_FILE);){
            if (in != null) {
                properties.load(in);
            }
        }
        catch (IOException e) {
            logger.error("Error while reading the project default properties, hence apply default values.", (Throwable)e);
        }
        return properties;
    }
}

