/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tools.osgilib;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.tools.CarbonTool;
import org.wso2.carbon.tools.exception.CarbonToolException;
import org.wso2.carbon.tools.osgilib.OSGiLibDeployerToolUtils;

public class OSGiLibDeployerTool
implements CarbonTool {
    private static final Logger logger = Logger.getLogger(OSGiLibDeployerTool.class.getName());

    @Override
    public void execute(String ... toolArgs) {
        if (toolArgs != null && toolArgs.length == 2) {
            String carbonProfile = toolArgs[0];
            String carbonHome = toolArgs[1];
            if (carbonProfile.isEmpty()) {
                logger.log(Level.INFO, OSGiLibDeployerToolUtils.getHelpMessage());
                return;
            }
            try {
                OSGiLibDeployerToolUtils.executeTool(carbonHome, carbonProfile);
            }
            catch (IOException | CarbonToolException e) {
                logger.log(Level.SEVERE, "Error when executing the OSGi-lib deployer tool", e);
            }
        } else {
            logger.log(Level.INFO, OSGiLibDeployerToolUtils.getHelpMessage());
        }
    }
}

