/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.das.core;

import java.util.Arrays;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.spi.MetricsExtension;
import org.wso2.carbon.metrics.das.core.config.model.DasReporterConfig;
import org.wso2.carbon.metrics.das.core.config.model.MetricsConfig;

@Component(name="org.wso2.carbon.metrics.das.core.DasMetricsExtension", service={MetricsExtension.class})
public class DasMetricsExtension
implements MetricsExtension {
    private static final Logger logger = LoggerFactory.getLogger(DasMetricsExtension.class);
    private String[] names;

    public void activate(ConfigProvider configProvider, MetricService metricService, MetricManagementService metricManagementService) {
        MetricsConfig metricsConfig;
        try {
            metricsConfig = (MetricsConfig)configProvider.getConfigurationObject(MetricsConfig.class);
        }
        catch (ConfigurationException e) {
            logger.error("Error loading Metrics Configuration", (Throwable)e);
            metricsConfig = new MetricsConfig();
        }
        Set<DasReporterConfig> dasReporterConfigs = metricsConfig.getReporting().getDas();
        if (dasReporterConfigs != null) {
            dasReporterConfigs.forEach(reporterBuilder -> {
                try {
                    metricManagementService.addReporter((ReporterBuilder)reporterBuilder);
                }
                catch (ReporterBuildException e) {
                    logger.warn("DAS Reporter build failed", (Throwable)e);
                }
            });
            this.names = (String[])dasReporterConfigs.stream().map(dasReporterConfig -> dasReporterConfig.getName()).toArray(String[]::new);
        }
    }

    public void deactivate(MetricService metricService, MetricManagementService metricManagementService) {
        if (this.names != null) {
            Arrays.stream(this.names).forEach(arg_0 -> ((MetricManagementService)metricManagementService).removeReporter(arg_0));
        }
    }

    @Reference(name="carbon.metrics.service", service=MetricService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetricService")
    protected void setMetricService(MetricService metricService) {
        if (logger.isDebugEnabled()) {
            logger.debug("Metric Service is available as an OSGi service.");
        }
    }

    protected void unsetMetricService(MetricService metricService) {
    }
}

