/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.das.core.config.model;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.annotation.Element;
import org.wso2.carbon.metrics.core.config.model.ScheduledReporterConfig;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.utils.Utils;
import org.wso2.carbon.metrics.das.core.config.model.DasConfig;
import org.wso2.carbon.metrics.das.core.reporter.impl.DasReporter;

public class DasReporterConfig
extends ScheduledReporterConfig
implements ReporterBuilder<DasReporter> {
    private static final Logger logger = LoggerFactory.getLogger(DasReporterConfig.class);
    @Element(description="Source of Metrics, which will be used to identify each metric sent in the streams")
    private String source;
    @Element(description="Alias referring to the DAS configuration")
    private DasConfig das;

    public DasReporterConfig() {
        super("DAS");
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public DasConfig getDas() {
        return this.das;
    }

    public void setDas(DasConfig das) {
        this.das = das;
    }

    public Optional<DasReporter> build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterBuildException {
        if (!this.isEnabled()) {
            return Optional.empty();
        }
        String type = this.das.getType();
        String receiverURL = this.das.getReceiverURL();
        String authURL = this.das.getAuthURL();
        String username = this.das.getUsername();
        String password = this.das.getPassword();
        String dataAgentConfigPath = this.das.getDataAgentConfigPath();
        if (type == null || type.trim().length() == 0) {
            throw new ReporterBuildException("Type is not specified for DAS Reporting.");
        }
        if (receiverURL == null || receiverURL.trim().length() == 0) {
            throw new ReporterBuildException("Receiver URL is not specified for DAS Reporting.");
        }
        if (username == null || username.trim().length() == 0) {
            throw new ReporterBuildException("Username is not specified for DAS Reporting.");
        }
        if (password == null || password.trim().length() == 0) {
            throw new ReporterBuildException("Password is not specified for DAS Reporting.");
        }
        if (this.source == null) {
            this.source = Utils.getDefaultSource();
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating DAS reporter for Metrics with source '%s', protocol '%s' and %d seconds polling period", this.source, type, this.getPollingPeriod()));
        }
        return Optional.of(new DasReporter(this.getName(), metricRegistry, this.getFilter(metricFilter), this.source, type, receiverURL, authURL, username, password, dataAgentConfigPath, this.getPollingPeriod()));
    }
}

