/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.httpmonitoring;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Path;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitoringDataPublisher;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitoringEvent;
import org.wso2.msf4j.analytics.httpmonitoring.config.HTTPMonitoringConfigBuilder;
import org.wso2.msf4j.analytics.httpmonitoring.config.model.HTTPMonitoringConfig;

public class HTTPMonitoringInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(HTTPMonitoringInterceptor.class);
    public static final String REFERER = "Referer";
    private Map<Method, MethodInterceptor> map = new ConcurrentHashMap<Method, MethodInterceptor>();
    private final boolean enabled;
    private final HTTPMonitoringDataPublisher httpMonitoringDataPublisher;

    public HTTPMonitoringInterceptor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating HTTP Monitoring Interceptor");
        }
        HTTPMonitoringConfig httpMonitoringConfig = HTTPMonitoringConfigBuilder.build();
        this.enabled = httpMonitoringConfig.isEnabled();
        this.httpMonitoringDataPublisher = this.enabled ? new HTTPMonitoringDataPublisher(httpMonitoringConfig.getDas()) : null;
    }

    private HTTPMonitored extractFinalAnnotation(Method method) {
        HTTPMonitored httpMon = method.getAnnotation(HTTPMonitored.class);
        if (httpMon == null) {
            httpMon = method.getDeclaringClass().getAnnotation(HTTPMonitored.class);
        }
        return httpMon;
    }

    public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) throws Exception {
        if (!this.enabled) {
            return true;
        }
        Method method = serviceMethodInfo.getMethod();
        MethodInterceptor methodInterceptor = this.map.get(method);
        if (methodInterceptor == null || !methodInterceptor.annotationScanned) {
            HTTPMonitored httpMon = this.extractFinalAnnotation(method);
            HTTPInterceptor interceptor = null;
            if (httpMon != null) {
                interceptor = new HTTPInterceptor(httpMon.tracing());
            }
            methodInterceptor = new MethodInterceptor(true, interceptor);
            this.map.put(method, methodInterceptor);
        }
        return methodInterceptor.preCall(request, responder, serviceMethodInfo);
    }

    public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) throws Exception {
        if (!this.enabled) {
            return;
        }
        Method method = serviceMethodInfo.getMethod();
        MethodInterceptor methodInterceptor = this.map.get(method);
        if (methodInterceptor != null) {
            methodInterceptor.postCall(request, status, serviceMethodInfo);
        }
    }

    private class HTTPInterceptor
    implements Interceptor {
        private static final String DEFAULT_TRACE_ID = "DEFAULT";
        private static final String DEFAULT_PARENT_REQUEST = "DEFAULT";
        private static final String MONITORING_EVENT = "MONITORING_EVENT";
        private static final String ACTIVITY_ID = "activity-id";
        private static final String PARENT_REQUEST = "parent-request";
        private String serviceClass;
        private String serviceName;
        private String serviceMethod;
        private String servicePath;
        private boolean tracing;

        private HTTPInterceptor(boolean tracing) {
            this.tracing = tracing;
        }

        boolean isTracing() {
            return this.tracing;
        }

        private String generateTraceId() {
            return UUID.randomUUID().toString();
        }

        private void handleTracing(Request request, HTTPMonitoringEvent httpMonitoringEvent) {
            String parentRequest;
            String traceId;
            if (this.isTracing()) {
                traceId = request.getHeader(ACTIVITY_ID);
                if (traceId == null) {
                    traceId = this.generateTraceId();
                }
                parentRequest = request.getHeader(PARENT_REQUEST);
            } else {
                traceId = "DEFAULT";
                parentRequest = "DEFAULT";
            }
            httpMonitoringEvent.setActivityId(traceId);
            httpMonitoringEvent.setParentRequest(parentRequest);
        }

        public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) {
            HTTPMonitoringEvent httpMonitoringEvent = new HTTPMonitoringEvent();
            httpMonitoringEvent.setTimestamp(System.currentTimeMillis());
            httpMonitoringEvent.setStartNanoTime(System.nanoTime());
            if (this.serviceClass == null) {
                Method method = serviceMethodInfo.getMethod();
                Class<?> serviceClass = method.getDeclaringClass();
                this.serviceClass = serviceClass.getName();
                this.serviceName = serviceClass.getSimpleName();
                this.serviceMethod = method.getName();
                if (serviceClass.isAnnotationPresent(Path.class)) {
                    Path path = serviceClass.getAnnotation(Path.class);
                    this.servicePath = path.value();
                }
            }
            httpMonitoringEvent.setServiceClass(this.serviceClass);
            httpMonitoringEvent.setServiceName(this.serviceName);
            httpMonitoringEvent.setServiceMethod(this.serviceMethod);
            httpMonitoringEvent.setRequestUri(request.getUri());
            httpMonitoringEvent.setServiceContext(this.servicePath);
            HttpHeaders httpHeaders = request.getHeaders();
            httpMonitoringEvent.setHttpMethod(request.getHttpMethod());
            httpMonitoringEvent.setContentType(httpHeaders.getHeaderString("Content-Type"));
            String contentLength = httpHeaders.getHeaderString("Content-Length");
            if (contentLength != null) {
                httpMonitoringEvent.setRequestSizeBytes(Long.parseLong(contentLength));
            }
            httpMonitoringEvent.setReferrer(httpHeaders.getHeaderString(HTTPMonitoringInterceptor.REFERER));
            this.handleTracing(request, httpMonitoringEvent);
            serviceMethodInfo.setAttribute(MONITORING_EVENT, (Object)httpMonitoringEvent);
            return true;
        }

        public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) {
            HTTPMonitoringEvent httpMonitoringEvent = (HTTPMonitoringEvent)serviceMethodInfo.getAttribute(MONITORING_EVENT);
            httpMonitoringEvent.setResponseTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - httpMonitoringEvent.getStartNanoTime()));
            httpMonitoringEvent.setResponseHttpStatusCode(status);
            HTTPMonitoringInterceptor.this.httpMonitoringDataPublisher.publishEvent(httpMonitoringEvent);
        }
    }

    private static class MethodInterceptor
    implements Interceptor {
        private final boolean annotationScanned;
        private final Interceptor interceptor;

        MethodInterceptor(boolean annotationScanned, Interceptor interceptor) {
            this.annotationScanned = annotationScanned;
            this.interceptor = interceptor;
        }

        public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) throws Exception {
            if (this.interceptor != null) {
                return this.interceptor.preCall(request, responder, serviceMethodInfo);
            }
            return true;
        }

        public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) throws Exception {
            if (this.interceptor != null) {
                this.interceptor.postCall(request, status, serviceMethodInfo);
            }
        }
    }
}

