/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.certificatevalidation.RevocationVerificationManager;

public class CertificateValidationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateValidationHandler.class);
    private SSLEngine sslEngine;
    private RevocationVerificationManager revocationVerifier;
    private int cacheSize;
    private int cacheDelay;

    public CertificateValidationHandler(SSLEngine sslEngine, int cacheDelay, int cacheSize) {
        this.sslEngine = sslEngine;
        this.cacheDelay = cacheDelay;
        this.cacheSize = cacheSize;
        this.revocationVerifier = null;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.revocationVerifier = new RevocationVerificationManager(this.cacheSize, this.cacheDelay);
        if (evt instanceof SslHandshakeCompletionEvent) {
            ctx.pipeline().remove((ChannelHandler)this);
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (!event.isSuccess() || !this.revocationVerifier.verifyRevocationStatus(this.sslEngine.getSession().getPeerCertificateChain())) {
                ctx.close();
                throw new SSLException("Certificate Chain Validation failed. Hence closing the channel");
            }
            ctx.fireChannelRead(evt);
            ctx.fireUserEventTriggered(evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Exception occurred in CertificateValidationHandler.", cause);
        ctx.fireExceptionCaught(cause);
    }
}

