/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.http2;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2Content;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.RequestCompleted;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SendingEntityBody;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SendingHeaders;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.Http2Reset;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Http2TargetHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Http2TargetHandler.class);
    private Http2Connection connection;
    private Http2ConnectionEncoder encoder;
    private Http2ClientChannel http2ClientChannel;

    public Http2TargetHandler(Http2Connection connection, Http2ConnectionEncoder encoder) {
        this.connection = connection;
        this.encoder = encoder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Http2Content) {
            Http2Content http2Content = (Http2Content)msg;
            try {
                new Http2RequestWriter(http2Content.getOutboundMsgHolder()).writeContent(ctx, http2Content.getHttpContent());
            }
            catch (Http2NoMoreStreamIdsException ex) {
                this.http2ClientChannel.removeFromConnectionPool();
                LOG.warn("Channel is removed from the connection pool : {}", (Object)ex.getMessage(), (Object)ex);
                http2Content.getOutboundMsgHolder().getResponseFuture().notifyHttpListener(ex);
            }
            catch (Http2Exception ex) {
                LOG.error("Failed to send the request : {}", (Object)ex.getMessage(), (Object)ex);
                http2Content.getOutboundMsgHolder().getResponseFuture().notifyHttpListener(ex);
            }
        } else if (msg instanceof Http2Reset) {
            Http2Reset resetMsg = (Http2Reset)msg;
            this.resetStream(ctx, resetMsg.getStreamId(), resetMsg.getError());
        } else {
            ctx.write(msg, promise);
        }
    }

    void resetStream(ChannelHandlerContext ctx, int streamId, Http2Error http2Error) {
        this.encoder.writeRstStream(ctx, streamId, http2Error.code(), ctx.newPromise());
        this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamReset(streamId));
        ctx.flush();
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.http2ClientChannel = http2ClientChannel;
    }

    public Http2ClientChannel getHttp2ClientChannel() {
        return this.http2ClientChannel;
    }

    public Http2ConnectionEncoder getEncoder() {
        return this.encoder;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2HeadersFrame) {
            this.onHeaderRead(ctx, (Http2HeadersFrame)msg);
        } else if (msg instanceof Http2DataFrame) {
            this.onDataRead(ctx, (Http2DataFrame)msg);
        } else if (msg instanceof Http2PushPromise) {
            this.onPushPromiseRead((Http2PushPromise)msg);
        } else if (msg instanceof Http2Reset) {
            this.onResetRead((Http2Reset)msg);
        }
    }

    private void onHeaderRead(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame) {
        int streamId = http2HeadersFrame.getStreamId();
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        boolean serverPush = false;
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
            if (outboundMsgHolder != null) {
                serverPush = true;
            } else {
                LOG.warn("Header Frame received on channel: {} with invalid stream id: {} ", (Object)this.http2ClientChannel, (Object)streamId);
                return;
            }
        }
        Http2MessageStateContext http2MessageStateContext = this.initHttp2MessageContext(outboundMsgHolder);
        http2MessageStateContext.getSenderState().readInboundResponseHeaders(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    private void onDataRead(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame) {
        int streamId = http2DataFrame.getStreamId();
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        boolean serverPush = false;
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
            if (outboundMsgHolder != null) {
                serverPush = true;
            } else {
                LOG.warn("Data Frame received on channel: {} with invalid stream id: {}", (Object)this.http2ClientChannel, (Object)streamId);
                return;
            }
        }
        Http2MessageStateContext http2MessageStateContext = this.getHttp2MessageContext(outboundMsgHolder);
        http2MessageStateContext.getSenderState().readInboundResponseBody(ctx, http2DataFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    private void onPushPromiseRead(Http2PushPromise http2PushPromise) {
        int streamId = http2PushPromise.getStreamId();
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        Http2MessageStateContext http2MessageStateContext = this.initHttp2MessageContext(outboundMsgHolder);
        http2MessageStateContext.getSenderState().readInboundPromise(http2PushPromise, outboundMsgHolder);
    }

    private void onResetRead(Http2Reset http2Reset) {
        int streamId = http2Reset.getStreamId();
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder != null) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new Exception("HTTP/2 stream " + streamId + " reset by the remote peer"));
        }
    }

    private Http2MessageStateContext initHttp2MessageContext(OutboundMsgHolder outboundMsgHolder) {
        Http2MessageStateContext http2MessageStateContext = this.getHttp2MessageContext(outboundMsgHolder);
        if (http2MessageStateContext == null) {
            http2MessageStateContext = new Http2MessageStateContext();
            http2MessageStateContext.setSenderState(new RequestCompleted(this, null));
            outboundMsgHolder.getRequest().setHttp2MessageStateContext(http2MessageStateContext);
        }
        return http2MessageStateContext;
    }

    private Http2MessageStateContext getHttp2MessageContext(OutboundMsgHolder outboundMsgHolder) {
        return outboundMsgHolder.getRequest().getHttp2MessageStateContext();
    }

    public class Http2RequestWriter {
        HttpCarbonMessage httpOutboundRequest;
        OutboundMsgHolder outboundMsgHolder;
        Http2MessageStateContext http2MessageStateContext;
        int streamId;

        Http2RequestWriter(OutboundMsgHolder outboundMsgHolder) {
            this.outboundMsgHolder = outboundMsgHolder;
            this.httpOutboundRequest = outboundMsgHolder.getRequest();
            this.http2MessageStateContext = this.httpOutboundRequest.getHttp2MessageStateContext();
            if (this.http2MessageStateContext == null) {
                this.http2MessageStateContext = new Http2MessageStateContext();
                this.httpOutboundRequest.setHttp2MessageStateContext(this.http2MessageStateContext);
            }
        }

        void writeContent(ChannelHandlerContext ctx, HttpContent msg) throws Http2Exception {
            try {
                if (!this.outboundMsgHolder.isFirstContentWritten()) {
                    this.httpOutboundRequest.getHttp2MessageStateContext().setSenderState(new SendingHeaders(Http2TargetHandler.this, this));
                    this.outboundMsgHolder.setFirstContentWritten(true);
                }
                this.http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, msg, this.http2MessageStateContext);
            }
            catch (RuntimeException ex) {
                this.httpOutboundRequest.getHttp2MessageStateContext().setSenderState(new SendingEntityBody(Http2TargetHandler.this, this));
                this.httpOutboundRequest.getHttp2MessageStateContext().getSenderState().writeOutboundRequestBody(ctx, (HttpContent)new DefaultLastHttpContent(), this.http2MessageStateContext);
            }
        }

        public Http2MessageStateContext getHttp2MessageStateContext() {
            return this.http2MessageStateContext;
        }

        public HttpCarbonMessage getHttpOutboundRequest() {
            return this.httpOutboundRequest;
        }

        public OutboundMsgHolder getOutboundMsgHolder() {
            return this.outboundMsgHolder;
        }

        public int getStreamId() {
            return this.streamId;
        }

        public void setStreamId(int streamId) {
            this.streamId = streamId;
        }
    }
}

