/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpointConnectionWorker;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpointFailureCallback;
import org.wso2.carbon.databridge.agent.endpoint.EventPublisherThreadPoolExecutor;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeThreadFactory;

public abstract class DataEndpoint {
    private static final Logger log = Logger.getLogger(DataEndpoint.class);
    private DataEndpointConnectionWorker connectionWorker;
    private GenericKeyedObjectPool transportPool;
    private int batchSize = 100;
    private EventPublisherThreadPoolExecutor threadPoolExecutor;
    private DataEndpointFailureCallback dataEndpointFailureCallback;
    private ExecutorService connectionService;
    private int maxPoolSize;
    private List<Event> events;
    private State state = State.INITIALIZING;
    private Semaphore immediateDispatchSemaphore;

    public DataEndpoint() {
        this.events = new ArrayList<Event>();
    }

    void collectAndSend(Event event) {
        this.events.add(event);
        if (this.events.size() >= this.batchSize) {
            this.threadPoolExecutor.submitJobAndSetState(new EventPublisher(this.events), this);
            this.events = new ArrayList<Event>();
        }
    }

    void flushEvents() {
        if (this.events.size() != 0) {
            this.threadPoolExecutor.submitJobAndSetState(new EventPublisher(this.events), this);
            this.events = new ArrayList<Event>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncSend(Event event) {
        ArrayList<Event> events = new ArrayList<Event>(1);
        events.add(event);
        EventPublisher eventPublisher = new EventPublisher(events);
        this.setStateBusy();
        this.acquireImmediateDispatchSemaphore();
        try {
            eventPublisher.run();
        }
        finally {
            this.releaseImmediateDispatchSemaphore();
        }
    }

    private void acquireImmediateDispatchSemaphore() {
        boolean acquired = false;
        do {
            try {
                this.immediateDispatchSemaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!acquired);
    }

    private void releaseImmediateDispatchSemaphore() {
        this.immediateDispatchSemaphore.release();
    }

    private void setStateBusy() {
        int permits = this.immediateDispatchSemaphore.availablePermits();
        if (permits <= 1) {
            this.setState(State.BUSY);
        }
    }

    void setState(State state) {
        if (!this.state.equals((Object)state)) {
            this.state = state;
        }
    }

    void connect() throws TransportException, DataEndpointAuthenticationException, DataEndpointException {
        if (this.connectionWorker == null) {
            throw new DataEndpointException("Data Endpoint is not initialized");
        }
        this.connectionService.submit(this.connectionWorker);
    }

    synchronized void syncConnect(String oldSessionId) throws DataEndpointException {
        if (oldSessionId == null || oldSessionId.equalsIgnoreCase(this.getDataEndpointConfiguration().getSessionId())) {
            if (this.connectionWorker != null) {
                this.connectionWorker.run();
            } else {
                throw new DataEndpointException("Data Endpoint is not initialized");
            }
        }
    }

    public void initialize(DataEndpointConfiguration dataEndpointConfiguration) throws DataEndpointException, DataEndpointAuthenticationException, TransportException {
        this.transportPool = dataEndpointConfiguration.getTransportPool();
        this.batchSize = dataEndpointConfiguration.getBatchSize();
        this.connectionWorker = new DataEndpointConnectionWorker();
        this.connectionWorker.initialize(this, dataEndpointConfiguration);
        this.threadPoolExecutor = new EventPublisherThreadPoolExecutor(dataEndpointConfiguration.getCorePoolSize(), dataEndpointConfiguration.getMaxPoolSize(), dataEndpointConfiguration.getKeepAliveTimeInPool(), dataEndpointConfiguration.getReceiverURL());
        this.connectionService = Executors.newSingleThreadExecutor((ThreadFactory)new DataBridgeThreadFactory("ConnectionService-" + dataEndpointConfiguration.getReceiverURL()));
        this.maxPoolSize = dataEndpointConfiguration.getMaxPoolSize();
        this.immediateDispatchSemaphore = new Semaphore(this.maxPoolSize);
        this.connect();
    }

    protected abstract String login(Object var1, String var2, String var3) throws DataEndpointAuthenticationException;

    protected abstract void logout(Object var1, String var2) throws DataEndpointAuthenticationException;

    public State getState() {
        return this.state;
    }

    void activate() {
        this.setState(State.ACTIVE);
    }

    void deactivate() {
        this.setState(State.UNAVAILABLE);
    }

    protected abstract void send(Object var1, List<Event> var2) throws DataEndpointException, SessionTimeoutException, UndefinedEventTypeException;

    protected DataEndpointConfiguration getDataEndpointConfiguration() {
        return this.connectionWorker.getDataEndpointConfiguration();
    }

    private Object getClient() throws DataEndpointException {
        try {
            return this.transportPool.borrowObject((Object)this.getDataEndpointConfiguration().getPublisherKey());
        }
        catch (Exception e) {
            throw new DataEndpointException("Cannot borrow client for " + this.getDataEndpointConfiguration().getPublisherKey(), e);
        }
    }

    private void returnClient(Object client) {
        try {
            this.transportPool.returnObject((Object)this.getDataEndpointConfiguration().getPublisherKey(), client);
        }
        catch (Exception e) {
            log.warn((Object)"Error occurred while returning object to connection pool", (Throwable)e);
            this.discardClient(client);
        }
    }

    private void discardClient(Object client) {
        if (client != null) {
            try {
                this.transportPool.invalidateObject((Object)this.getDataEndpointConfiguration().getPublisherKey(), client);
            }
            catch (Exception e) {
                log.error((Object)"Error while invalidating the client ", (Throwable)e);
            }
        }
    }

    void registerDataEndpointFailureCallback(DataEndpointFailureCallback callback) {
        this.dataEndpointFailureCallback = callback;
    }

    private void handleFailedEvents(List<Event> events) {
        this.deactivate();
        this.dataEndpointFailureCallback.tryResendEvents(events, this);
    }

    boolean isConnected() {
        return !this.state.equals((Object)State.UNAVAILABLE);
    }

    public String toString() {
        return "( Receiver URL : " + this.getDataEndpointConfiguration().getReceiverURL() + ", Authentication URL : " + this.getDataEndpointConfiguration().getAuthURL() + ")";
    }

    public void shutdown() {
        log.info((Object)("Shutdown triggered for data publisher endpoint URL - " + this.getDataEndpointConfiguration().getReceiverURL()));
        while (this.threadPoolExecutor.getActiveCount() != 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.connectionWorker.disconnect(this.getDataEndpointConfiguration());
        this.connectionService.shutdownNow();
        this.threadPoolExecutor.shutdownNow();
        try {
            this.connectionService.awaitTermination(10L, TimeUnit.SECONDS);
            this.threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info((Object)("Completed shutdown for data publisher endpoint URL - " + this.getDataEndpointConfiguration().getReceiverURL()));
    }

    public abstract String getClientPoolFactoryClass();

    public abstract String getSecureClientPoolFactoryClass();

    class EventPublisher
    implements Runnable {
        List<Event> events;
        private Semaphore semaphore;

        public EventPublisher(List<Event> events) {
            this.events = events;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String sessionId = DataEndpoint.this.getDataEndpointConfiguration().getSessionId();
            try {
                this.publish();
            }
            catch (SessionTimeoutException e) {
                try {
                    if (sessionId == null || sessionId.equalsIgnoreCase(DataEndpoint.this.getDataEndpointConfiguration().getSessionId())) {
                        DataEndpoint.this.syncConnect(sessionId);
                    }
                    this.publish();
                }
                catch (UndefinedEventTypeException ex) {
                    log.error((Object)"Unable to process this event.", (Throwable)ex);
                    this.semaphoreRelease();
                }
                catch (Exception ex) {
                    log.error((Object)"Unexpected error occurred while sending the event. ", (Throwable)ex);
                    DataEndpoint.this.handleFailedEvents(this.events);
                }
            }
            catch (DataEndpointException e) {
                log.error((Object)"Unable to send events to the endpoint. ", (Throwable)e);
                DataEndpoint.this.handleFailedEvents(this.events);
            }
            catch (UndefinedEventTypeException e) {
                log.error((Object)"Unable to process this event.", (Throwable)e);
                this.semaphoreRelease();
            }
            catch (Exception ex) {
                log.error((Object)"Unexpected error occurred while sending the event. ", (Throwable)ex);
                DataEndpoint.this.handleFailedEvents(this.events);
            }
            catch (Throwable t) {
                log.error((Object)"Unexpected error occurred while sending events. ", t);
                this.semaphoreRelease();
                DataEndpoint.this.deactivate();
            }
            finally {
                if (DataEndpoint.this.state.equals((Object)State.BUSY)) {
                    DataEndpoint.this.activate();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current threads count is : " + DataEndpoint.this.threadPoolExecutor.getActiveCount() + ", maxPoolSize is : " + DataEndpoint.this.maxPoolSize + ", therefore state is now : " + (Object)((Object)DataEndpoint.this.getState()) + " at time : " + System.nanoTime()));
                }
            }
        }

        public void setPoolSemaphore(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        private void publish() throws DataEndpointException, SessionTimeoutException, UndefinedEventTypeException {
            Object client = DataEndpoint.this.getClient();
            try {
                DataEndpoint.this.send(client, this.events);
                this.semaphoreRelease();
            }
            finally {
                DataEndpoint.this.returnClient(client);
            }
        }

        private void semaphoreRelease() {
            if (this.semaphore != null) {
                this.semaphore.release();
            }
        }
    }

    public static enum State {
        ACTIVE,
        UNAVAILABLE,
        BUSY,
        INITIALIZING;

    }
}

