/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.databridge.agent.endpoint.DataEndpoint;
import org.wso2.carbon.databridge.commons.utils.DataBridgeThreadFactory;

public class EventPublisherThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Semaphore semaphore;

    public EventPublisherThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTimeInPool, String receiverURL) {
        super(corePoolSize, maxPoolSize, keepAliveTimeInPool, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DataBridgeThreadFactory(receiverURL));
        this.semaphore = new Semaphore(maxPoolSize);
    }

    @Override
    public void execute(Runnable task) {
        boolean acquired = false;
        do {
            try {
                this.semaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!acquired);
        super.execute(task);
    }

    public void submitJobAndSetState(DataEndpoint.EventPublisher publisher, DataEndpoint dataEndpoint) {
        int permits = this.semaphore.availablePermits();
        if (permits <= 1) {
            dataEndpoint.setState(DataEndpoint.State.BUSY);
        }
        publisher.setPoolSemaphore(this.semaphore);
        this.submit(new Thread(publisher));
    }
}

