/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint.binary;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.client.AbstractSecureClientPoolFactory;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointSecurityException;

public class BinarySecureClientPoolFactory
extends AbstractSecureClientPoolFactory {
    private static final Logger log = Logger.getLogger(BinarySecureClientPoolFactory.class);

    public BinarySecureClientPoolFactory(String trustStore, String trustStorePassword) {
        super(trustStore, trustStorePassword);
    }

    @Override
    public Object createClient(String protocol, String hostName, int port) throws DataEndpointException, DataEndpointSecurityException, DataEndpointAgentConfigurationException {
        if (protocol.equalsIgnoreCase(DataEndpointConfiguration.Protocol.SSL.toString())) {
            int timeout = AgentHolder.getInstance().getDataEndpointAgent("BINARY").getAgentConfiguration().getSocketTimeoutMS();
            String sslProtocols = AgentHolder.getInstance().getDataEndpointAgent("BINARY").getAgentConfiguration().getSslEnabledProtocols();
            String ciphers = AgentHolder.getInstance().getDataEndpointAgent("BINARY").getAgentConfiguration().getCiphers();
            try {
                SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket sslSocket = (SSLSocket)sslsocketfactory.createSocket(hostName, port);
                sslSocket.setSoTimeout(timeout);
                if (sslProtocols != null && sslProtocols.length() != 0) {
                    String[] sslProtocolsArray = sslProtocols.split(",");
                    sslSocket.setEnabledProtocols(sslProtocolsArray);
                }
                if (ciphers != null && ciphers.length() != 0) {
                    String[] ciphersArray = ciphers.split(",");
                    sslSocket.setEnabledCipherSuites(ciphersArray);
                } else {
                    sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
                }
                return sslSocket;
            }
            catch (IOException e) {
                throw new DataEndpointException("Error while opening socket to " + hostName + ":" + port + ". " + e.getMessage(), e);
            }
        }
        throw new DataEndpointException("Unsupported protocol: " + protocol + ". Currently only " + DataEndpointConfiguration.Protocol.SSL.toString() + " supported.");
    }

    @Override
    public boolean validateClient(Object client) {
        Socket socket = (Socket)client;
        return socket.isConnected();
    }

    @Override
    public void terminateClient(Object client) {
        Socket socket = null;
        try {
            socket = (Socket)client;
            socket.close();
        }
        catch (IOException e) {
            log.warn((Object)("Cannot close the socket successfully from " + socket.getLocalAddress().getHostAddress() + ":" + socket.getPort()));
        }
    }
}

