/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.SessionManager;
import org.wso2.msf4j.config.TransportsFileConfiguration;
import org.wso2.msf4j.interceptor.RequestInterceptor;
import org.wso2.msf4j.interceptor.ResponseInterceptor;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.HttpConnectorPortBindingListener;
import org.wso2.msf4j.internal.MSF4JHttpConnectorListener;
import org.wso2.msf4j.internal.MSF4JWSConnectorListener;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.websocket.EndpointsRegistryImpl;
import org.wso2.msf4j.util.Utils;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;
import org.wso2.transport.http.netty.contract.config.ServerBootstrapConfiguration;
import org.wso2.transport.http.netty.contract.config.TransportsConfiguration;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnectorListener;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpWsConnectorFactory;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.message.HttpConnectorUtil;

public class MicroservicesRunner {
    private static final Logger log = LoggerFactory.getLogger(MicroservicesRunner.class);
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final String MSF4J_HOST = "msf4j.host";
    private static final String TRANSPORTS_NETTY_CONF = "transports.netty.conf";
    protected List<ServerConnector> serverConnectors = new ArrayList<ServerConnector>();
    private EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
    private MicroservicesRegistryImpl msRegistry = new MicroservicesRegistryImpl();
    private long startTime = System.currentTimeMillis();
    private boolean isStarted;

    public MicroservicesRunner(int ... ports) {
        this.configureTransport(ports);
    }

    public MicroservicesRunner() {
        this.configureTransport();
    }

    public MicroservicesRunner(TransportsFileConfiguration transportsFileConfiguration) {
        this.configureTransport(transportsFileConfiguration);
    }

    public MicroservicesRunner deploy(Object ... microservice) {
        this.checkState();
        this.msRegistry.addService(microservice);
        return this;
    }

    public MicroservicesRunner deploy(String basePath, Object microservice) {
        this.msRegistry.addService(basePath, microservice);
        return this;
    }

    public MicroservicesRunner deployWebSocketEndpoint(Object webSocketEndpoint) {
        this.endpointsRegistry.addEndpoint(webSocketEndpoint);
        return this;
    }

    public MicroservicesRunner setSessionManager(SessionManager sessionManager) {
        this.msRegistry.setSessionManager(sessionManager);
        return this;
    }

    public MicroservicesRunner addGlobalRequestInterceptor(RequestInterceptor ... requestInterceptor) {
        this.msRegistry.addGlobalRequestInterceptor(requestInterceptor);
        return this;
    }

    public MicroservicesRunner addGlobalResponseInterceptor(ResponseInterceptor ... responseInterceptor) {
        this.msRegistry.addGlobalResponseInterceptor(responseInterceptor);
        return this;
    }

    public MicroservicesRunner addInterceptor(Interceptor ... interceptor) {
        this.msRegistry.addGlobalRequestInterceptor(interceptor);
        this.msRegistry.addGlobalResponseInterceptor(interceptor);
        return this;
    }

    public MicroservicesRunner addExceptionMapper(ExceptionMapper ... exceptionMapper) {
        this.checkState();
        this.msRegistry.addExceptionMapper(exceptionMapper);
        return this;
    }

    protected void configureTransport(int ... ports) {
        DefaultHttpWsConnectorFactory connectorFactory = new DefaultHttpWsConnectorFactory();
        ServerBootstrapConfiguration bootstrapConfiguration = new ServerBootstrapConfiguration(new HashMap());
        for (int port : ports) {
            ListenerConfiguration listenerConfiguration = new ListenerConfiguration("netty-" + port, System.getProperty(MSF4J_HOST, DEFAULT_HOST), port);
            DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()), this.msRegistry);
            ServerConnector serverConnector = connectorFactory.createServerConnector(bootstrapConfiguration, listenerConfiguration);
            this.serverConnectors.add(serverConnector);
        }
    }

    protected void configureTransport() {
        String transportYaml = System.getProperty(TRANSPORTS_NETTY_CONF);
        if (transportYaml == null || transportYaml.isEmpty()) {
            DefaultHttpWsConnectorFactory connectorFactory = new DefaultHttpWsConnectorFactory();
            ServerBootstrapConfiguration bootstrapConfiguration = new ServerBootstrapConfiguration(new HashMap());
            ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
            ServerConnector serverConnector = connectorFactory.createServerConnector(bootstrapConfiguration, listenerConfiguration);
            DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()), this.msRegistry);
            this.serverConnectors.add(serverConnector);
        } else {
            try {
                TransportsFileConfiguration transportsFileConfiguration = (TransportsFileConfiguration)ConfigProviderFactory.getConfigProvider((Path)Paths.get(transportYaml, new String[0]), null).getConfigurationObject(TransportsFileConfiguration.class);
                TransportsConfiguration transportsConfiguration = Utils.transformTransportConfiguration(transportsFileConfiguration);
                Map transportProperties = HttpConnectorUtil.getTransportProperties((TransportsConfiguration)transportsConfiguration);
                int bossGroup = transportProperties.get("server.bootstrap.boss.group.size") != null ? ((Integer)transportProperties.get("server.bootstrap.boss.group.size")).intValue() : Runtime.getRuntime().availableProcessors();
                int workerGroup = transportProperties.get("server.bootstrap.worker.group.size") != null ? (Integer)transportProperties.get("server.bootstrap.worker.group.size") : Runtime.getRuntime().availableProcessors() * 2;
                DefaultHttpWsConnectorFactory connectorFactory = new DefaultHttpWsConnectorFactory(bossGroup, workerGroup, workerGroup);
                ServerBootstrapConfiguration serverBootstrapConfiguration = HttpConnectorUtil.getServerBootstrapConfiguration((Set)transportsConfiguration.getTransportProperties());
                for (ListenerConfiguration listenerConfiguration : transportsConfiguration.getListenerConfigurations()) {
                    ServerConnector serverConnector = connectorFactory.createServerConnector(serverBootstrapConfiguration, listenerConfiguration);
                    DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()), this.msRegistry);
                    this.serverConnectors.add(serverConnector);
                }
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error loading yaml Configuration", e);
            }
        }
    }

    protected void configureTransport(TransportsFileConfiguration transportsFileConfiguration) {
        if (transportsFileConfiguration != null) {
            TransportsConfiguration transportsConfiguration = Utils.transformTransportConfiguration(transportsFileConfiguration);
            Map transportProperties = HttpConnectorUtil.getTransportProperties((TransportsConfiguration)transportsConfiguration);
            int bossGroup = transportProperties.get("server.bootstrap.boss.group.size") != null ? ((Integer)transportProperties.get("server.bootstrap.boss.group.size")).intValue() : Runtime.getRuntime().availableProcessors();
            int workerGroup = transportProperties.get("server.bootstrap.worker.group.size") != null ? (Integer)transportProperties.get("server.bootstrap.worker.group.size") : Runtime.getRuntime().availableProcessors() * 2;
            DefaultHttpWsConnectorFactory connectorFactory = new DefaultHttpWsConnectorFactory(bossGroup, workerGroup, workerGroup);
            ServerBootstrapConfiguration serverBootstrapConfiguration = HttpConnectorUtil.getServerBootstrapConfiguration((Set)transportsConfiguration.getTransportProperties());
            for (ListenerConfiguration listenerConfiguration : transportsConfiguration.getListenerConfigurations()) {
                ServerConnector serverConnector = connectorFactory.createServerConnector(serverBootstrapConfiguration, listenerConfiguration);
                DataHolder.getInstance().getMicroservicesRegistries().put(Util.createServerConnectorID((String)listenerConfiguration.getHost(), (int)listenerConfiguration.getPort()), this.msRegistry);
                this.serverConnectors.add(serverConnector);
            }
        } else {
            this.configureTransport();
        }
    }

    private void checkState() {
        if (this.isStarted) {
            throw new IllegalStateException("Microservices runner already started");
        }
    }

    public void start() {
        this.msRegistry.getSessionManager().init();
        this.handleServiceLifecycleMethods();
        MSF4JHttpConnectorListener msf4JHttpConnectorListener = new MSF4JHttpConnectorListener();
        MSF4JWSConnectorListener msf4JWSConnectorListener = new MSF4JWSConnectorListener();
        this.serverConnectors.forEach(serverConnector -> {
            ServerConnectorFuture serverConnectorFuture = serverConnector.start();
            serverConnectorFuture.setHttpConnectorListener((HttpConnectorListener)msf4JHttpConnectorListener);
            serverConnectorFuture.setWebSocketConnectorListener((WebSocketConnectorListener)msf4JWSConnectorListener);
            serverConnectorFuture.setPortBindingEventListener((PortBindingEventListener)new HttpConnectorPortBindingListener());
            this.isStarted = true;
            log.info("Microservices server started in " + (System.currentTimeMillis() - this.startTime) + "ms");
        });
    }

    public void stop() {
        this.serverConnectors.forEach(ServerConnector::stop);
        log.info("Microservices server stopped");
    }

    public MicroservicesRegistryImpl getMsRegistry() {
        return this.msRegistry;
    }

    protected void handleServiceLifecycleMethods() {
        this.msRegistry.initServices();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MicroservicesRunner.this.msRegistry.preDestroyServices();
            }
        });
    }
}

