/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tools.osgilib;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.carbon.launcher.extensions.OSGiLibBundleDeployerUtils;
import org.wso2.carbon.tools.exception.CarbonToolException;

class OSGiLibDeployerToolUtils {
    private static final Logger logger = Logger.getLogger(OSGiLibDeployerToolUtils.class.getName());

    OSGiLibDeployerToolUtils() {
    }

    static void executeTool(String carbonHome, String profile) throws CarbonToolException, IOException {
        if (carbonHome == null || carbonHome.isEmpty()) {
            throw new CarbonToolException("Invalid Carbon home specified: " + carbonHome);
        }
        if (profile != null) {
            Path osgiLibDirectoryPath = Paths.get(carbonHome, "lib");
            logger.log(Level.FINE, "Loading the new OSGi bundle information from lib folder...");
            List newBundlesInfo = OSGiLibBundleDeployerUtils.getBundlesInfo((Path)osgiLibDirectoryPath);
            logger.log(Level.FINE, "Successfully loaded the new OSGi bundle information from lib folder");
            if (profile.equals("ALL")) {
                OSGiLibBundleDeployerUtils.getCarbonProfiles((String)carbonHome).forEach(carbonProfile -> {
                    try {
                        OSGiLibBundleDeployerUtils.updateOSGiLib((String)carbonHome, (String)carbonProfile, (List)newBundlesInfo);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Failed to update the OSGi bundle information of Carbon Runtime: " + carbonProfile, e);
                    }
                });
            } else {
                try {
                    OSGiLibBundleDeployerUtils.updateOSGiLib((String)carbonHome, (String)profile, (List)newBundlesInfo);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Failed to update the OSGi bundle information of Carbon Runtime: " + profile, e);
                }
            }
        }
    }

    static String getHelpMessage() {
        return "Incorrect usage of the OSGi-lib deployer tool.\n\nInstructions: sh osgi-lib.sh [profile]\nprofile - name of the Carbon Runtime to be updated\n\nKeyword option for profile:\nALL\tUpdate OSGi-lib bundle information of all Carbon Runtimes (ex: sh osgi-lib.sh ALL/osgi-lib.bat ALL)\n";
    }
}

