/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.wso2.carbon.uiserver.api.util.Multilocational;
import org.wso2.carbon.uiserver.api.util.Overridable;
import org.wso2.carbon.uiserver.internal.impl.OverriddenExtension;

public class Extension
implements Multilocational,
Overridable<Extension> {
    private final String name;
    private final String type;
    private final List<String> paths;

    public Extension(String name, String type, String path) {
        this(name, type, Collections.singletonList(path));
    }

    protected Extension(String name, String type, List<String> paths) {
        this.name = name;
        this.type = type;
        this.paths = paths;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public Extension override(Extension override) {
        if (!this.canOverrideBy(override)) {
            throw new IllegalArgumentException(this + " cannot be overridden by " + override + " .");
        }
        return new OverriddenExtension(this, override);
    }

    @Override
    public Extension getBase() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Extension)) {
            return false;
        }
        Extension other = (Extension)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.paths, other.paths);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return "Extension{name='" + this.name + "', type='" + this.type + "', paths=" + this.paths + "}";
    }
}

