/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class I18nResource {
    private final Locale locale;
    private final Map<String, String> messages;

    public I18nResource(Locale locale, Map<String, String> messages) {
        this.locale = locale;
        this.messages = messages;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMessage(String messageKey, Object[] messageParams, String defaultMessage) {
        String message = this.messages.get(messageKey);
        if (message == null) {
            return defaultMessage;
        }
        return messageParams == null || messageParams.length == 0 ? message : new MessageFormat(message, this.locale).format(messageParams);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof I18nResource)) {
            return false;
        }
        I18nResource other = (I18nResource)obj;
        return Objects.equals(this.locale, other.locale) && Objects.equals(this.messages, other.messages);
    }

    public int hashCode() {
        return Objects.hash(this.locale);
    }

    public String toString() {
        return "I18nResource{locale=" + this.locale + "}";
    }

    public static Locale getMatchingLocale(String languageRanges, Set<Locale> availableLocales) {
        List<Locale> matchingLocales;
        if (languageRanges == null || languageRanges.isEmpty()) {
            return null;
        }
        try {
            matchingLocales = Locale.filter(Locale.LanguageRange.parse(languageRanges), availableLocales);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return matchingLocales.isEmpty() ? null : matchingLocales.get(0);
    }
}

