/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.annotation.Element;

@Configuration(namespace="wso2.carbon-ui-server", description="Configurations for Carbon UI Server")
public class ServerConfiguration {
    @Element(description="Configurations for web apps.\nHere key is the name of the web app abd value is configurations for that web app.")
    private Map<String, AppConfiguration> apps = Collections.emptyMap();

    public Optional<AppConfiguration> getConfigurationForApp(String appName) {
        return Optional.ofNullable(this.apps.get(appName));
    }

    public static class AppConfiguration {
        @Element(description="Context path of this web app.\nThis overrides the default context path (which is '/'+<app-name>) of the app. Context path should start with a '/' (e.g. '/foo').")
        private String contextPath;
        @Element(description="ID of the HTTP listener configuration that this web app should be deployed.\n'listenerConfigurations' can be found under 'wso2.transport.http' namespace. If absent, this web app will be deployed to all available HTTPS transports.")
        private String transportId;

        public Optional<String> getContextPath() throws IllegalArgumentException {
            if (this.contextPath != null && this.contextPath.charAt(0) != '/') {
                throw new IllegalArgumentException("Configured context path '" + this.contextPath + "' is invalid as it does not start with a '/'.");
            }
            return Optional.ofNullable(this.contextPath);
        }

        public Optional<String> getTransportId() throws IllegalArgumentException {
            if (this.transportId != null && this.transportId.isEmpty()) {
                throw new IllegalArgumentException("Configured transport ID is invalid as it cannot be a empty.");
            }
            return Optional.ofNullable(this.transportId);
        }
    }
}

