/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.wso2.carbon.uiserver.api.util.Multilocational;
import org.wso2.carbon.uiserver.api.util.Overridable;
import org.wso2.carbon.uiserver.internal.impl.OverriddenTheme;

public class Theme
implements Multilocational,
Overridable<Theme> {
    private final String name;
    private final List<String> paths;

    public Theme(String name, String path) {
        this(name, Collections.singletonList(path));
    }

    protected Theme(String name, List<String> paths) {
        this.name = name;
        this.paths = paths;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public Theme override(Theme override) {
        if (!this.canOverrideBy(override)) {
            throw new IllegalArgumentException(this + " cannot be overridden by " + override + " .");
        }
        return new OverriddenTheme(this, override);
    }

    @Override
    public Theme getBase() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Theme)) {
            return false;
        }
        Theme other = (Theme)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.paths, other.paths);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Theme{name='" + this.name + "', paths=" + this.paths + "}";
    }
}

