/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.api.http;

import java.util.Collections;
import java.util.Map;

public class HttpResponse {
    public static final int STATUS_OK = 200;
    public static final int STATUS_MOVED_PERMANENTLY = 301;
    public static final int STATUS_FOUND = 302;
    public static final int STATUS_NOT_MODIFIED = 304;
    public static final int STATUS_BAD_REQUEST = 400;
    public static final int STATUS_UNAUTHORIZED = 401;
    public static final int STATUS_FORBIDDEN = 403;
    public static final int STATUS_NOT_FOUND = 404;
    public static final int STATUS_INTERNAL_SERVER_ERROR = 500;
    public static final String CONTENT_TYPE_WILDCARD = "*/*";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    public static final String CONTENT_TYPE_IMAGE_PNG = "image/png";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String HEADER_LOCATION = "Location";
    public static final String HEADER_X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options";
    public static final String HEADER_X_XSS_PROTECTION = "X-XSS-Protection";
    public static final String HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_EXPIRES = "Expires";
    public static final String HEADER_PRAGMA = "Pragma";
    public static final String HEADER_X_FRAME_OPTIONS = "X-Frame-Options";
    private int status;
    private Object content;
    private String contentType;
    private Map<String, String> headers;
    private Map<String, String> cookies;

    public HttpResponse(int status, Object content, String contentType) {
        this(status, content, contentType, Collections.emptyMap(), Collections.emptyMap());
    }

    public HttpResponse(int status, Object content, String contentType, Map<String, String> headers, Map<String, String> cookies) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
        this.headers = Collections.unmodifiableMap(headers);
        this.cookies = Collections.unmodifiableMap(cookies);
    }

    public int getStatus() {
        return this.status;
    }

    public Object getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String toString() {
        return "HttpResponse{status=" + this.status + ", content=" + this.content + ", contentType='" + this.contentType + "'}";
    }
}

