/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.startupresolver.StartupServiceUtils;
import org.wso2.carbon.uiserver.api.ServerConfiguration;
import org.wso2.carbon.uiserver.internal.deployment.AppDeploymentEventListener;
import org.wso2.carbon.uiserver.internal.deployment.listener.AppTransportBinder;
import org.wso2.carbon.uiserver.internal.deployment.listener.CarbonUiServer;
import org.wso2.carbon.uiserver.internal.deployment.listener.RestApiDeployer;
import org.wso2.carbon.uiserver.internal.deployment.msf4j.MicroservicesRegistrar;
import org.wso2.carbon.uiserver.internal.io.deployment.ArtifactAppDeployer;
import org.wso2.carbon.uiserver.spi.RestApiProvider;
import org.wso2.carbon.uiserver.spi.Server;

@Component(service={RequiredCapabilityListener.class}, immediate=true, property={"componentName=carbon-ui-server-startup-listener"})
public class StartupListener
implements RequiredCapabilityListener {
    protected static final String CARBON_COMPONENT_NAME = "carbon-ui-server-startup-listener";
    private static final Logger LOGGER = LoggerFactory.getLogger(StartupListener.class);
    private BundleContext bundleContext;
    private final Set<ServiceRegistration<?>> serviceRegistrations = new HashSet();
    private final Set<RestApiProvider> restApiProviders = ConcurrentHashMap.newKeySet();
    private ServerConfiguration serverConfiguration;
    private MicroservicesRegistrar microservicesRegistrar;
    private AppTransportBinder appTransportBinder;
    private RestApiDeployer restApiDeployer;
    private CarbonUiServer carbonUiServer;
    private ArtifactAppDeployer appDeployer;

    @Reference(service=RestApiProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetRestApiProvider")
    protected void setRestApiProvider(RestApiProvider restApiProvider) {
        this.restApiProviders.add(restApiProvider);
        StartupServiceUtils.updateServiceCache((String)CARBON_COMPONENT_NAME, RestApiProvider.class);
        LOGGER.debug("An instance of class '{}' registered as a REST APIs provider for '{}' web app.", (Object)restApiProvider.getAppName(), (Object)restApiProvider.getClass().getName());
    }

    protected void unsetRestApiProvider(RestApiProvider restApiProvider) {
        this.restApiProviders.remove(restApiProvider);
        LOGGER.debug("An instance of class '{}' unregistered as a REST APIs provider for '{}' web app.", (Object)restApiProvider.getAppName(), (Object)restApiProvider.getClass().getName());
    }

    @Reference(service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigProvider")
    protected void setConfigProvider(ConfigProvider configProvider) {
        try {
            this.serverConfiguration = (ServerConfiguration)configProvider.getConfigurationObject(ServerConfiguration.class);
        }
        catch (ConfigurationException e) {
            this.serverConfiguration = new ServerConfiguration();
            LOGGER.error("Cannot load server configurations from 'deployment.yaml'. Falling-back to defaults.", (Throwable)e);
        }
    }

    protected void unsetConfigProvider(ConfigProvider configProvider) {
        LOGGER.debug("An instance of class '{}' unregistered as a config provider.", (Object)configProvider.getClass().getName());
    }

    @Reference(service=MicroservicesRegistrar.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMicroservicesRegistrar")
    protected void setMicroservicesRegistrar(MicroservicesRegistrar microservicesRegistrar) {
        this.microservicesRegistrar = microservicesRegistrar;
    }

    protected void unsetMicroservicesRegistrar(MicroservicesRegistrar microservicesRegistrar) {
        this.microservicesRegistrar = null;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        LOGGER.debug("{} activated.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate() {
        this.bundleContext = null;
        this.serviceRegistrations.forEach(ServiceRegistration::unregister);
        this.restApiProviders.clear();
        this.serverConfiguration = null;
        this.microservicesRegistrar = null;
        this.appTransportBinder.close();
        this.appTransportBinder = null;
        this.restApiDeployer.close();
        this.restApiDeployer = null;
        this.carbonUiServer.close();
        this.carbonUiServer = null;
        this.appDeployer.close();
        this.appDeployer = null;
        LOGGER.debug("{} deactivated.", (Object)this.getClass().getName());
    }

    public void onAllRequiredCapabilitiesAvailable() {
        this.appTransportBinder = new AppTransportBinder(this.microservicesRegistrar, this.serverConfiguration);
        this.restApiDeployer = new RestApiDeployer(this.restApiProviders, this.microservicesRegistrar, this.serverConfiguration);
        this.carbonUiServer = new CarbonUiServer();
        this.appDeployer = new ArtifactAppDeployer((List<AppDeploymentEventListener>)ImmutableList.of((Object)this.appTransportBinder, (Object)this.restApiDeployer, (Object)this.carbonUiServer), this.serverConfiguration);
        Hashtable<String, Boolean> properties = new Hashtable<String, Boolean>(Collections.singletonMap("skipCarbonStartupResolver", true));
        this.serviceRegistrations.add(this.bundleContext.registerService(Deployer.class, (Object)this.appDeployer, properties));
        LOGGER.debug("Web app deployer '{}' registered as a Carbon Deployer.", (Object)this.appDeployer.getClass().getName());
        this.serviceRegistrations.add(this.bundleContext.registerService(Server.class, (Object)this.carbonUiServer, properties));
        LOGGER.debug("Server '{}' registered as a Carbon UI Server.", (Object)this.carbonUiServer.getClass().getName());
        LOGGER.debug("Carbon UI Server Startup Listener fully activated.");
    }
}

