/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment.msf4j;

import java.util.Objects;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.uiserver.internal.http.HttpTransport;
import org.wso2.msf4j.Microservice;

public class MicroserviceRegistration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceRegistration.class);
    private final HttpTransport httpTransport;
    private final ServiceRegistration<Microservice> microserviceRegistration;

    public MicroserviceRegistration(HttpTransport httpTransport, ServiceRegistration<Microservice> microserviceRegistration) {
        this.httpTransport = httpTransport;
        this.microserviceRegistration = microserviceRegistration;
    }

    public HttpTransport getRegisteredHttpTransport() {
        return this.httpTransport;
    }

    public void unregister() {
        this.microserviceRegistration.unregister();
        LOGGER.debug("Microservice unregistered from HTTP transport {}.", (Object)this.httpTransport);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MicroserviceRegistration)) {
            return false;
        }
        MicroserviceRegistration other = (MicroserviceRegistration)obj;
        return Objects.equals(this.httpTransport, other.httpTransport) && Objects.equals(this.microserviceRegistration, other.microserviceRegistration);
    }

    public int hashCode() {
        return Objects.hash(this.httpTransport, this.microserviceRegistration);
    }

    public String toString() {
        return "MicroserviceRegistration{httpTransport=" + this.httpTransport + ", microserviceRegistration=" + this.microserviceRegistration + "}";
    }
}

