/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment.msf4j;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.uiserver.internal.deployment.msf4j.MicroserviceRegistration;
import org.wso2.carbon.uiserver.internal.http.HttpTransport;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.MicroservicesServer;

@Component(service={MicroservicesRegistrar.class}, immediate=true)
public class MicroservicesRegistrar {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroservicesRegistrar.class);
    private final Set<HttpTransport> httpTransports = new HashSet<HttpTransport>();
    private BundleContext bundleContext;
    private String propertyKeyListenerInterfaceId;
    private String propertyKeyContextPath;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        LOGGER.debug("Microservices registrar activated.");
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        this.bundleContext = null;
        LOGGER.debug("Microservices registrar deactivated.");
    }

    @Reference(service=MicroservicesServer.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetMicroservicesServer")
    protected void setMicroservicesServer(MicroservicesServer microservicesServer) {
        microservicesServer.getListenerConfigurations().forEach((listenerInterfaceId, listenerConfiguration) -> {
            HttpTransport httpTransport = new HttpTransport((String)listenerInterfaceId, listenerConfiguration.getId(), listenerConfiguration.getScheme(), listenerConfiguration.getHost(), listenerConfiguration.getPort());
            this.httpTransports.add(httpTransport);
            LOGGER.debug("HTTP transport {} is available.", (Object)httpTransport);
        });
        try {
            Class<?> msf4jConstants = microservicesServer.getClass().getClassLoader().loadClass("org.wso2.msf4j.internal.MSF4JConstants");
            this.propertyKeyListenerInterfaceId = msf4jConstants.getDeclaredField("CHANNEL_ID").get(null).toString();
            this.propertyKeyContextPath = msf4jConstants.getDeclaredField("CONTEXT_PATH").get(null).toString();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            this.propertyKeyListenerInterfaceId = "listener.interface.id";
            this.propertyKeyContextPath = "contextPath";
            LOGGER.debug("Cannot access constants in MSF4JConstants class via reflection.", (Throwable)e);
        }
        LOGGER.debug("Microservices Server '{}' registered.", (Object)microservicesServer.getClass().getName());
    }

    protected void unsetMicroservicesServer(MicroservicesServer microservicesServer) {
        this.httpTransports.clear();
        LOGGER.debug("Microservices Server '{}' unregistered.", (Object)microservicesServer.getClass().getName());
    }

    public MicroserviceRegistration register(Microservice microservice, String contextPath, String listenerConfigurationId) throws IllegalArgumentException {
        HttpTransport httpTransport = this.httpTransports.stream().filter(ht -> Objects.equals(ht.getListenerConfigurationId(), listenerConfigurationId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find a HTTP transport for listener configuration ID '" + listenerConfigurationId + "'. Available HTTP transport: " + this.httpTransports));
        ServiceRegistration<Microservice> serviceRegistration = this.register(microservice, contextPath, httpTransport);
        return new MicroserviceRegistration(httpTransport, serviceRegistration);
    }

    public Set<MicroserviceRegistration> register(Microservice microservice, String contextPath) {
        return this.httpTransports.stream().filter(HttpTransport::isSecured).map(ht -> new MicroserviceRegistration((HttpTransport)ht, this.register(microservice, contextPath, (HttpTransport)ht))).collect(Collectors.toSet());
    }

    private ServiceRegistration<Microservice> register(Microservice microservice, String contextPath, HttpTransport httpTransport) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put(this.propertyKeyListenerInterfaceId, httpTransport.getListenerInterfaceId());
        ((Dictionary)properties).put(this.propertyKeyContextPath, contextPath);
        ((Dictionary)properties).put("skipCarbonStartupResolver", true);
        ServiceRegistration registration = this.bundleContext.registerService(Microservice.class, (Object)microservice, properties);
        LOGGER.debug("Microservice {} registered to {} for context path '{}'.", new Object[]{microservice, httpTransport, contextPath});
        return registration;
    }
}

