/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment.msf4j;

import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.wso2.carbon.uiserver.api.http.HttpRequest;
import org.wso2.carbon.uiserver.api.http.HttpResponse;
import org.wso2.carbon.uiserver.internal.http.msf4j.Msf4jHttpRequest;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;

public class WebappMicroservice
implements Microservice {
    private static final String PATH_ROOT = "";
    private static final String PATH_ALL = ".*";
    private final Function<HttpRequest, HttpResponse> httpListener;

    public WebappMicroservice(Function<HttpRequest, HttpResponse> httpListener) {
        this.httpListener = httpListener;
    }

    @GET
    @Path(value=".*")
    public Response getAll(@Context Request request) {
        return this.getImpl(request);
    }

    @GET
    @Path(value="")
    public Response getRoot(@Context Request request) {
        return this.getImpl(request);
    }

    private Response getImpl(@Context Request request) {
        Msf4jHttpRequest httpRequest = new Msf4jHttpRequest(request);
        return this.buildResponse(this.httpListener.apply(httpRequest));
    }

    private Response buildResponse(HttpResponse httpResponse) {
        Response.ResponseBuilder responseBuilder = Response.status((int)httpResponse.getStatus());
        if (httpResponse.getContent() != null) {
            responseBuilder.entity(httpResponse.getContent()).type(httpResponse.getContentType());
        }
        httpResponse.getHeaders().entrySet().forEach(entry -> responseBuilder.header((String)entry.getKey(), entry.getValue()));
        httpResponse.getCookies().entrySet().forEach(entry -> responseBuilder.cookie(new NewCookie[]{new NewCookie((String)entry.getKey(), (String)entry.getValue())}));
        return responseBuilder.build();
    }
}

