/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.deployment.parser;

import org.wso2.carbon.uiserver.internal.exception.ConfigurationException;
import org.wso2.carbon.uiserver.internal.exception.FileOperationException;
import org.wso2.carbon.uiserver.internal.reference.FileReference;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlFileParser {
    public static <T> T parse(FileReference yamlFile, Class<T> type) throws ConfigurationException {
        Object loadedBean;
        try {
            loadedBean = new Yaml((BaseConstructor)new ClassLoaderConstructor(type)).loadAs(yamlFile.getContent(), type);
        }
        catch (FileOperationException e) {
            throw new ConfigurationException("Cannot read the YAML configuration file '" + yamlFile.getFilePath() + "'.", e);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot parse the YAML configuration file '" + yamlFile.getFilePath() + "'.", e);
        }
        if (loadedBean == null) {
            throw new ConfigurationException("Cannot load the YAML configuration file '" + yamlFile.getFilePath() + "' as it is empty.");
        }
        return (T)loadedBean;
    }

    private static class ClassLoaderConstructor
    extends Constructor {
        private final ClassLoader classLoader;

        public ClassLoaderConstructor(Class aClass) {
            super(Object.class);
            this.classLoader = aClass.getClassLoader();
        }

        protected Class<?> getClassForName(String name) throws ClassNotFoundException {
            return Class.forName(name, true, this.classLoader);
        }
    }
}

