/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.http;

import java.util.Locale;
import java.util.Objects;
import org.wso2.carbon.uiserver.internal.http.util.IpAddressUtils;

public class HttpTransport {
    private final String listenerInterfaceId;
    private final String listenerConfigurationId;
    private final String scheme;
    private final String host;
    private final int port;

    public HttpTransport(String listenerInterfaceId, String listenerConfigurationId, String scheme, String host, int port) {
        this.listenerInterfaceId = listenerInterfaceId;
        this.listenerConfigurationId = listenerConfigurationId;
        this.scheme = scheme.toLowerCase(Locale.ENGLISH);
        this.host = host;
        this.port = port;
    }

    public String getListenerInterfaceId() {
        return this.listenerInterfaceId;
    }

    public String getListenerConfigurationId() {
        return this.listenerConfigurationId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecured() {
        return Objects.equals(this.scheme, "https");
    }

    public String getUrlFor(String contextPath) {
        String properHost = this.host;
        if ("localhost".equals(this.host) || "127.0.0.1".equals(this.host) || "0.0.0.0".equals(this.host) || "::1".equals(this.host)) {
            properHost = IpAddressUtils.getLocalIpAddress().orElse(this.host);
        }
        return this.scheme + "://" + properHost + ":" + this.port + contextPath;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpTransport)) {
            return false;
        }
        HttpTransport other = (HttpTransport)obj;
        return Objects.equals(this.listenerInterfaceId, other.listenerInterfaceId) && Objects.equals(this.listenerConfigurationId, other.listenerConfigurationId);
    }

    public int hashCode() {
        return Objects.hash(this.listenerInterfaceId, this.listenerConfigurationId);
    }

    public String toString() {
        return "HttpTransport{listenerInterfaceId='" + this.listenerInterfaceId + "', listenerConfigurationId='" + this.listenerConfigurationId + "', scheme='" + this.scheme + "', host='" + this.host + "', port=" + this.port + '}';
    }
}

