/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.api.exception.PageNotFoundException;
import org.wso2.carbon.uiserver.api.exception.PageRedirectException;
import org.wso2.carbon.uiserver.api.exception.RenderingException;
import org.wso2.carbon.uiserver.api.http.HttpRequest;
import org.wso2.carbon.uiserver.api.http.HttpResponse;
import org.wso2.carbon.uiserver.internal.http.ResponseBuilder;

public class PageRequestDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageRequestDispatcher.class);
    private final App app;

    public PageRequestDispatcher(App app) {
        this.app = app;
    }

    public HttpResponse serve(HttpRequest request) {
        try {
            String html = this.app.renderPage(request);
            return ResponseBuilder.ok(html, "text/html").headers(this.app.getConfiguration().getResponseHeaders().forPages()).build();
        }
        catch (RenderingException e) {
            LOGGER.error("An error occurred when rendering page for request '{}'.", (Object)request, (Object)e);
            return ResponseBuilder.serverError("A server error occurred while rendering page for page request.").build();
        }
        catch (PageNotFoundException e) {
            return ResponseBuilder.notFound("Page '" + request.getUriWithoutContextPath() + "' does not exists.").build();
        }
        catch (PageRedirectException e) {
            return ResponseBuilder.status(e.getHttpStatusCode()).header("Location", e.getRedirectUrl()).build();
        }
    }
}

