/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.http.msf4j;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wso2.carbon.uiserver.api.http.HttpRequest;
import org.wso2.msf4j.Request;

public class Msf4jHttpRequest
implements HttpRequest {
    private static final String PROPERTY_HTTP_VERSION = "HTTP_VERSION";
    private static final String PROPERTY_IS_SECURED_CONNECTION = "IS_SECURED_CONNECTION";
    private final Request msf4jRequest;
    private final String method;
    private final Map<String, Cookie> cookies;
    private final Map<String, String> headers;
    private final String uri;
    private final String contextPath;
    private final String uriWithoutContextPath;
    private final String queryString;
    private final Map<String, List<String>> queryParams;

    public Msf4jHttpRequest(Request request) {
        String rawQueryString;
        String rawUriPath;
        this.msf4jRequest = request;
        this.method = request.getHttpMethod();
        String rawUri = request.getUri();
        int uriPathEndIndex = rawUri.indexOf(63);
        if (uriPathEndIndex == -1) {
            rawUriPath = rawUri;
            rawQueryString = null;
        } else {
            rawUriPath = rawUri.substring(0, uriPathEndIndex);
            rawQueryString = rawUri.substring(uriPathEndIndex + 1, rawUri.length());
        }
        this.uri = QueryStringDecoder.decodeComponent((String)rawUriPath);
        this.contextPath = HttpRequest.getContextPath(this.uri);
        this.uriWithoutContextPath = HttpRequest.getUriWithoutContextPath(this.uri);
        this.queryString = rawQueryString;
        this.queryParams = rawQueryString != null ? Collections.unmodifiableMap(new QueryStringDecoder(rawQueryString, false).parameters()) : Collections.emptyMap();
        Map<String, String> httpHeaders = request.getHeaders().getRequestHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((List)entry.getValue()).get(0)));
        this.headers = Collections.unmodifiableMap(httpHeaders);
        String cookieHeader = httpHeaders.get("Cookie");
        this.cookies = cookieHeader == null ? Collections.emptyMap() : ServerCookieDecoder.STRICT.decode(cookieHeader).stream().collect(Collectors.toMap(Cookie::name, Function.identity()));
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getProtocol() {
        return (String)this.msf4jRequest.getProperty(PROPERTY_HTTP_VERSION);
    }

    @Override
    public boolean isSecure() {
        return (Boolean)this.msf4jRequest.getProperty(PROPERTY_IS_SECURED_CONNECTION);
    }

    @Override
    public String getUrl() {
        throw new UnsupportedOperationException("To be implemented");
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getUriWithoutContextPath() {
        return this.uriWithoutContextPath;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getCookieValue(String cookieName) {
        Cookie cookie = this.cookies.get(cookieName);
        return cookie == null ? null : cookie.value();
    }

    @Override
    public String toString() {
        return "{\"method\": \"" + this.method + "\", \"uri\": \"" + this.uri + "\", \"query\": \"" + this.queryString + "\", \"protocol\": \"" + this.getProtocol() + "\"}";
    }
}

