/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.io.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.deployment.engine.Artifact;
import org.wso2.carbon.deployment.engine.ArtifactType;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.deployment.engine.exception.CarbonDeploymentException;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.api.ServerConfiguration;
import org.wso2.carbon.uiserver.internal.deployment.AppCreator;
import org.wso2.carbon.uiserver.internal.deployment.AppDeploymentEventListener;
import org.wso2.carbon.uiserver.internal.deployment.AppRegistry;
import org.wso2.carbon.uiserver.internal.exception.AppCreationException;
import org.wso2.carbon.uiserver.internal.exception.AppDeploymentEventListenerException;
import org.wso2.carbon.uiserver.internal.impl.OverriddenApp;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactAppReference;
import org.wso2.carbon.uiserver.internal.reference.AppReference;

public class ArtifactAppDeployer
implements Deployer {
    private static final String ARTIFACT_TYPE = "web-ui-app";
    private static final String DEPLOYMENT_LOCATION = "file:web-ui-apps";
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactAppDeployer.class);
    private final ArtifactType<String> artifactType;
    private final URL deploymentLocation;
    private final AppRegistry appRegistry;
    private final List<AppDeploymentEventListener> appDeploymentEventListeners;
    private final ServerConfiguration serverConfiguration;

    public ArtifactAppDeployer(List<AppDeploymentEventListener> appDeploymentEventListeners, ServerConfiguration serverConfiguration) {
        this.appDeploymentEventListeners = appDeploymentEventListeners;
        this.serverConfiguration = serverConfiguration;
        this.artifactType = new ArtifactType((Object)ARTIFACT_TYPE);
        this.deploymentLocation = ArtifactAppDeployer.getLocationUrl();
        this.appRegistry = new AppRegistry();
    }

    public void init() {
        LOGGER.debug("Carbon UI server app deployer initialized.");
    }

    public Object deploy(Artifact artifact) throws CarbonDeploymentException {
        App deployingApp;
        Path appPath = artifact.getFile().toPath();
        if (!ArtifactAppDeployer.isValidAppArtifact(appPath)) {
            throw new CarbonDeploymentException("Artifact located in '" + appPath + "'is not a valid web app.");
        }
        App createdApp = this.createApp(appPath);
        Optional<App> previouslyCreatedOverridableApp = this.appRegistry.find(createdApp::canOverrideBy);
        if (previouslyCreatedOverridableApp.isPresent()) {
            LOGGER.info("Undeploying {} in order to merge it with {} and re-deploy the merged web app.", (Object)previouslyCreatedOverridableApp.get(), (Object)createdApp);
            this.publishAppUndeploymentEvent(previouslyCreatedOverridableApp.get());
            this.appRegistry.add(createdApp);
            deployingApp = new OverriddenApp(previouslyCreatedOverridableApp.get(), createdApp);
        } else {
            deployingApp = createdApp;
        }
        this.publishAppDeploymentEvent(deployingApp);
        return this.appRegistry.add(deployingApp);
    }

    public void undeploy(Object key) throws CarbonDeploymentException {
        Optional<App> removingApp = this.appRegistry.remove(key.toString());
        if (removingApp.isPresent()) {
            Optional<App> overriddenApp = this.appRegistry.find(app -> app.hasOverriddenBy(removingApp.get()));
            if (overriddenApp.isPresent()) {
                LOGGER.info("{} was overridden by the just undeployed {}. Therefore it will be undeployed and base {} will be restored.", new Object[]{overriddenApp.get(), removingApp.get(), overriddenApp.get().getBase()});
                this.appRegistry.remove(overriddenApp.get());
                this.publishAppUndeploymentEvent(overriddenApp.get());
                this.publishAppDeploymentEvent(overriddenApp.get().getBase());
            } else {
                this.publishAppUndeploymentEvent(removingApp.get());
            }
        } else {
            LOGGER.warn("Cannot find a deployed app for artifact key '{}'.", key);
        }
    }

    public Object update(Artifact artifact) throws CarbonDeploymentException {
        LOGGER.debug("Ignored update of web app artifact at '{}'.", (Object)artifact.getPath());
        return artifact.getKey();
    }

    public URL getLocation() {
        return this.deploymentLocation;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public void close() {
        this.appRegistry.clear();
    }

    private void publishAppDeploymentEvent(App app) throws CarbonDeploymentException {
        for (AppDeploymentEventListener listener : this.appDeploymentEventListeners) {
            try {
                listener.appDeploymentEvent(app);
            }
            catch (AppDeploymentEventListenerException e) {
                throw new CarbonDeploymentException("App deployment event listener '" + listener + "' threw an exception on app '" + app.getName() + "' deployment event.", (Exception)e);
            }
        }
        LOGGER.debug("Web app '{}' in '{}' deployed successfully.", (Object)app.getName(), (Object)app.getHighestPriorityPath());
    }

    private void publishAppUndeploymentEvent(App app) throws CarbonDeploymentException {
        for (AppDeploymentEventListener listener : this.appDeploymentEventListeners) {
            try {
                listener.appUndeploymentEvent(app.getName());
            }
            catch (AppDeploymentEventListenerException e) {
                throw new CarbonDeploymentException("App deployment event listener '" + listener + "' threw an exception on app '" + app.getName() + "' undeployment event.", (Exception)e);
            }
        }
        LOGGER.debug("Web app '{}' in '{}' undeployed successfully.", (Object)app.getName(), (Object)app.getHighestPriorityPath());
    }

    private App createApp(Path appPath) throws CarbonDeploymentException {
        ArtifactAppReference appReference = new ArtifactAppReference(appPath);
        String appContextPath = this.getAppContextPath(appReference);
        try {
            return AppCreator.createApp(appReference, appContextPath);
        }
        catch (AppCreationException e) {
            throw new CarbonDeploymentException("Cannot create web app '" + appReference.getName() + "' from artifact '" + appReference.getPath() + "' to deploy for context path '" + appContextPath + "'.", (Exception)e);
        }
    }

    private String getAppContextPath(AppReference appReference) throws CarbonDeploymentException {
        String appName = appReference.getName();
        try {
            return this.serverConfiguration.getConfigurationForApp(appName).flatMap(ServerConfiguration.AppConfiguration::getContextPath).orElse("/" + appName);
        }
        catch (IllegalArgumentException e) {
            throw new CarbonDeploymentException("Cannot deploy web app '" + appName + "' as the configured app context path is invalid.", (Exception)e);
        }
    }

    private static boolean isValidAppArtifact(Path appPath) throws CarbonDeploymentException {
        try {
            return Files.exists(appPath, new LinkOption[0]) && Files.isDirectory(appPath, new LinkOption[0]) && Files.isReadable(appPath) && !Files.isHidden(appPath);
        }
        catch (IOException e) {
            throw new CarbonDeploymentException("Cannot access web app artifact in '" + appPath + "'.", (Exception)e);
        }
    }

    private static URL getLocationUrl() {
        try {
            return new URL(DEPLOYMENT_LOCATION);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Invalid URL '{}' as app deployment location.", (Object)DEPLOYMENT_LOCATION, (Object)e);
            return null;
        }
    }
}

