/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.uiserver.internal.io.reference;

import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.wso2.carbon.uiserver.internal.exception.FileOperationException;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactAppReference;
import org.wso2.carbon.uiserver.internal.io.reference.ArtifactFileReference;
import org.wso2.carbon.uiserver.internal.reference.FileReference;
import org.wso2.carbon.uiserver.internal.reference.PageReference;

public class ArtifactPageReference
implements PageReference {
    private final Path pageFile;
    private final ArtifactAppReference appReference;

    public ArtifactPageReference(Path pageFile, ArtifactAppReference appReference) {
        this.pageFile = pageFile;
        this.appReference = appReference;
    }

    @Override
    public String getPathPattern() throws FileOperationException {
        StringBuilder sb = new StringBuilder();
        Path pagesDirectory = this.appReference.getPagesDirectory().relativize(this.pageFile);
        for (Path path : pagesDirectory) {
            sb.append('/').append(FilenameUtils.removeExtension((String)path.toString()));
        }
        return sb.toString();
    }

    @Override
    public FileReference getHtmlFile() {
        return new ArtifactFileReference(this.pageFile);
    }
}

